/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.DocumentationTargetProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import com.intellij.python.ruff.codeinsight.RuffRuleDocumentationTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffErrorCodeDocumentationProvider;", "Lcom/intellij/platform/backend/documentation/DocumentationTargetProvider;", "<init>", "()V", "documentationTargets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffErrorCodeDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffErrorCodeDocumentationProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeDocumentationProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n30#2,2:51\n*S KotlinDebug\n*F\n+ 1 RuffErrorCodeDocumentationProvider.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeDocumentationProvider\n*L\n43#1:51,2\n*E\n"})
public final class RuffErrorCodeDocumentationProvider
implements DocumentationTargetProvider {
    @NotNull
    public List<DocumentationTarget> documentationTargets(@NotNull PsiFile file, int offset) {
        TomlLiteral tomlLiteral;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof TomlFile)) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement = ((TomlFile)file).findElementAt(offset);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        if (element instanceof TomlLiteral) {
            tomlLiteral = (TomlLiteral)element;
        } else if (element.getParent() instanceof TomlLiteral) {
            PsiElement psiElement2 = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlLiteral");
            tomlLiteral = (TomlLiteral)psiElement2;
        } else {
            return CollectionsKt.emptyList();
        }
        TomlLiteral literal = tomlLiteral;
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\"', '\''};
        String text = StringsKt.trim((String)string, (char[])cArray);
        if (!RuffDocumentationUtil.INSTANCE.isRuffErrorCode(text)) {
            return CollectionsKt.emptyList();
        }
        if (!RuffDocumentationUtil.INSTANCE.isRuffCodeElement(literal)) {
            return CollectionsKt.emptyList();
        }
        Project project = literal.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RuffService> serviceClass$iv = RuffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RuffRuleInfo ruffRuleInfo = ((RuffService)object).getRuleInformation().get(text);
        if (ruffRuleInfo == null) {
            return CollectionsKt.emptyList();
        }
        RuffRuleInfo ruleInfo = ruffRuleInfo;
        Project project2 = literal.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return CollectionsKt.listOf((Object)new RuffRuleDocumentationTarget(ruleInfo, project2));
    }
}

