/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUiUtil;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.statistic.SwitchSessionUsagesCollector;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSessionAction
extends ActionGroup
implements DumbAware {
    public ChooseSessionAction() {
        this.setPopup(true);
        this.getTemplatePresentation().setPerformGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChooseSessionAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (AnAction.EMPTY_ARRAY == null) {
            ChooseSessionAction.$$$reportNull$$$0(1);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(2);
        }
        Presentation p = e.getPresentation();
        if ("ServicesToolbar".equals(e.getPlace())) {
            p.setEnabledAndVisible(false);
            return;
        }
        ActionContext context = ChooseSessionAction.getContext(e);
        if (context == null) {
            p.setEnabledAndVisible(false);
            return;
        }
        DatabaseSession session = context.getSession();
        String text = DatabaseBundle.message((String)"choose.session.action.switch.text", (Object[])new Object[0]);
        p.setVisible(true);
        p.setEnabled(context.isEnabled());
        p.setText(text, false);
        p.setIcon(e.isFromActionToolbar() ? SessionsUiUtil.getIcon((boolean)session.isConnected()) : null);
        p.setPerformGroup(p.isEnabled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionContext context;
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(3);
        }
        if ((context = ChooseSessionAction.getContext(e)) == null || !context.isEnabled()) {
            return;
        }
        RunQueryInConsoleIntentionAction.Manager.chooseAndRunRunners(DatabaseBundle.message((String)"sessions.chooser.title", (Object[])new Object[0]), context.getRunners(), null, e);
    }

    @Nullable
    private static ActionContext getContext(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(4);
        }
        if (ChooseSessionAction.contextMenuInvokedInsideSelection(e) || ChooseSessionAction.contextMenuInvokedOnResultSet(e)) {
            return null;
        }
        SessionClient client = (SessionClient)e.getData(SessionClientHolder.CLIENT_KEY);
        if (client instanceof JdbcConsole) {
            return new ConsoleActionContext((JdbcConsole)client);
        }
        if (client instanceof DataGridSessionClient) {
            return new DataGridActionContext((DataGridSessionClient)client);
        }
        return null;
    }

    public static boolean contextMenuInvokedInsideSelection(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(5);
        }
        return PlatformUtils.isDataGrip() && e.getPlace().equals("EditorPopup") && EditorUtil.isCaretInsideSelection((Caret)((Caret)e.getData(CommonDataKeys.CARET)));
    }

    private static boolean contextMenuInvokedOnResultSet(@NotNull AnActionEvent e) {
        DataGrid grid;
        DataGridSessionClient client;
        if (e == null) {
            ChooseSessionAction.$$$reportNull$$$0(6);
        }
        return (client = DataGridUtil.getDataGridClient(grid = GridUtil.getDataGrid((DataContext)e.getDataContext()))) == null && grid != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseSessionAction";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contextMenuInvokedInsideSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contextMenuInvokedOnResultSet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static abstract class ActionContext {
        protected final DatabaseSessionClientWithFile myClient;

        ActionContext(@NotNull DatabaseSessionClientWithFile client) {
            if (client == null) {
                ActionContext.$$$reportNull$$$0(0);
            }
            this.myClient = client;
        }

        @NotNull
        public DatabaseSession getSession() {
            DatabaseSession databaseSession = (DatabaseSession)this.myClient.getSession();
            if (databaseSession == null) {
                ActionContext.$$$reportNull$$$0(1);
            }
            return databaseSession;
        }

        public boolean isEnabled() {
            return this.getSession().isIdle();
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getRunners() {
            DatabaseSession session = this.getSession();
            VirtualFile file = this.myClient.getVirtualFile();
            Consumer consumer = newSession -> {
                if (newSession != session) {
                    SwitchSessionUsagesCollector.Companion.log(file, session, (DatabaseSession)newSession);
                    this.setSession((DatabaseSession)newSession);
                }
            };
            String title = SessionsUtil.getSessionTitle((VirtualFile)file);
            List<PersistenceConsoleProvider.Runner> list = DatabaseRunners.getSessionRunners(session, title, (Consumer<? super DatabaseSession>)consumer);
            if (list == null) {
                ActionContext.$$$reportNull$$$0(2);
            }
            return list;
        }

        protected abstract void setSession(@NotNull DatabaseSession var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSessionAction$ActionContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction$ActionContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConsoleActionContext
    extends ActionContext {
        ConsoleActionContext(@NotNull JdbcConsole client) {
            if (client == null) {
                ConsoleActionContext.$$$reportNull$$$0(0);
            }
            super((DatabaseSessionClientWithFile)client);
        }

        @Override
        protected void setSession(@NotNull DatabaseSession newSession) {
            if (newSession == null) {
                ConsoleActionContext.$$$reportNull$$$0(1);
            }
            JdbcConsoleProvider.reattachConsole(newSession.getProject(), newSession, this.myClient.getVirtualFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSession";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction$ConsoleActionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSession";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DataGridActionContext
    extends ActionContext {
        DataGridActionContext(@NotNull DataGridSessionClient client) {
            if (client == null) {
                DataGridActionContext.$$$reportNull$$$0(0);
            }
            super(client);
        }

        @Override
        protected void setSession(@NotNull DatabaseSession newSession) {
            if (newSession == null) {
                DataGridActionContext.$$$reportNull$$$0(1);
            }
            ((DataGridSessionClient)this.myClient).setSession(newSession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSession";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSessionAction$DataGridActionContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSession";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

