/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.impl.HttpRequestConverter;
import com.intellij.httpClient.execution.impl.HttpRequestExecutionSupportKt;
import com.intellij.httpClient.execution.impl.HttpRequestFallbackHandlerProvider;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.run.HttpClientSettings;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/execution/impl/HttpRequestRunSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/execution/RestClientRequest;", "<init>", "()V", "canProcess", "", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "getRequestConverter", "Lcom/intellij/httpClient/execution/impl/HttpRequestConverter;", "supportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "needsScheme", "getNeedsScheme", "()Z", "supportedSchemes", "", "getSupportedSchemes", "()Ljava/util/List;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpRequestExecutionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestExecutionSupport.kt\ncom/intellij/httpClient/execution/impl/HttpRequestRunSupport\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n50#2:43\n1#3:44\n*S KotlinDebug\n*F\n+ 1 HttpRequestExecutionSupport.kt\ncom/intellij/httpClient/execution/impl/HttpRequestRunSupport\n*L\n22#1:43\n*E\n"})
public class HttpRequestRunSupport
implements RequestExecutionSupport<RestClientRequest> {
    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && CollectionsKt.contains((Iterable)HttpRequestExecutionSupportKt.getHTTP_SCHEMES(), (Object)requestContext.getScheme()) && !CollectionsKt.listOf((Object[])(objectArray = new String[]{"GRAPHQL", "GRPC"})).contains(requestContext.getMethod());
    }

    @Override
    @NotNull
    public RequestHandler<RestClientRequest> getRequestHandler() {
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        Object object = (HttpRequestFallbackHandlerProvider)(application != null ? application.getService(HttpRequestFallbackHandlerProvider.class) : null);
        if (object == null || (object = object.getRequestHandler()) == null) {
            object = new HttpRequestHandlerV2();
        }
        return object;
    }

    @NotNull
    public HttpRequestConverter getRequestConverter() {
        return new HttpRequestConverter();
    }

    @Override
    @NotNull
    public Collection<String> supportedMethods(@Nullable Project project) {
        Object object;
        block3: {
            block2: {
                object = project;
                if (object == null) break block2;
                Project it = object;
                boolean bl = false;
                List<String> list2 = HttpClientSettings.Companion.getInstance(project).getSupportedMethods();
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object customMethods = object;
        return SetsKt.plus(HttpClientExtensionLexemesDefaultManager.getMethods(), (Iterable)((Iterable)customMethods));
    }

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return this.supportedMethods(null);
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return HttpRequestExecutionSupportKt.getHTTP_SCHEMES();
    }
}

