/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.preScript;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.run.preScript.HttpClientPreScriptCryptoSupportKt;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0006\u000f\u0010\u0011\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport;", "", "<init>", "()V", "hmacSupport", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$HmacSupport;", "sha1", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuilder;", "sha3", "bits", "", "sha256", "sha512", "md5", "sha384", "DigestHolder", "DigestBuilder", "DigestBuildable", "HmacSupport", "HmacInitializer", "Companion", "intellij.httpClient.executor"})
public final class HttpClientPreScriptCryptoSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SHA_256 = "SHA-256";
    @NotNull
    private static final String SHA_512 = "SHA-512";
    @NotNull
    private static final String SHA_1 = "SHA-1";
    @NotNull
    private static final String SHA_384 = "SHA-384";
    @NotNull
    private static final String MD5 = "MD5";
    @NotNull
    private static final String HMAC_SHA_256 = "HmacSHA256";
    @NotNull
    private static final String HMAC_SHA_512 = "HmacSHA512";
    @NotNull
    private static final String HMAC_SHA_1 = "HmacSHA1";
    @NotNull
    private static final String HMAC_SHA_384 = "HmacSHA384";
    @NotNull
    private static final String HMAC_MD5 = "HmacMD5";

    @NotNull
    public final HmacSupport hmacSupport() {
        return new HmacSupport();
    }

    @NotNull
    public final DigestBuilder sha1() {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_1);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(messageDigest));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @NotNull
    public final DigestBuilder sha3(@NotNull String bits) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        var2_2 = bits;
        switch (var2_2.hashCode()) {
            case 49747: {
                if (!var2_2.equals("256")) {
                    throw new Exception("Unsupported SHA3-" + bits);
                }
                ** GOTO lbl18
            }
            case 49652: {
                if (!var2_2.equals("224")) {
                    throw new Exception("Unsupported SHA3-" + bits);
                }
                ** GOTO lbl18
            }
            case 52502: {
                if (!var2_2.equals("512")) {
                    throw new Exception("Unsupported SHA3-" + bits);
                }
                ** GOTO lbl18
            }
            case 50799: {
                if (var2_2.equals("384") == false) throw new Exception("Unsupported SHA3-" + bits);
lbl18:
                // 4 sources

                v0 = MessageDigest.getInstance("SHA3-" + bits);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(v0));
            }
        }
        throw new Exception("Unsupported SHA3-" + bits);
    }

    @NotNull
    public final DigestBuilder sha256() {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(messageDigest));
    }

    @NotNull
    public final DigestBuilder sha512() {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_512);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(messageDigest));
    }

    @NotNull
    public final DigestBuilder md5() {
        MessageDigest messageDigest = MessageDigest.getInstance(MD5);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(messageDigest));
    }

    @NotNull
    public final DigestBuilder sha384() {
        MessageDigest messageDigest = MessageDigest.getInstance(SHA_384);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return new DigestBuilder(new DigestBuildable.MessageDigestAdapter(messageDigest));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$Companion;", "", "<init>", "()V", "SHA_256", "", "SHA_512", "SHA_1", "SHA_384", "MD5", "HMAC_SHA_256", "HMAC_SHA_512", "HMAC_SHA_1", "HMAC_SHA_384", "HMAC_MD5", "findCharset", "Ljava/nio/charset/Charset;", "encoding", "hexToBytes", "", "hexText", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpClientPreScriptCryptoSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientPreScriptCryptoSupport.kt\ncom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Charset findCharset(String encoding) {
            Object object;
            try {
                Object object2;
                block5: {
                    block4: {
                        object2 = encoding;
                        if (object2 == null) break block4;
                        String it = object2;
                        boolean bl = false;
                        Charset charset = Charset.forName(it);
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                        object2 = charset;
                        if (charset != null) break block5;
                    }
                    object2 = Charsets.UTF_8;
                }
                object = object2;
            }
            catch (UnsupportedCharsetException e) {
                Object[] objectArray = new Object[]{encoding};
                throw new IllegalArgumentException(HttpClientExecutorBundle.message("http.client.crypto.support.unknown.encoding.error", objectArray));
            }
            Object charset = object;
            return charset;
        }

        private final byte[] hexToBytes(String hexText) {
            if (!(hexText.length() % 2 == 0)) {
                boolean bl = false;
                Object[] objectArray = new Object[]{hexText.length()};
                String string = HttpClientExecutorBundle.message("http.client.crypto.support.hex.length.error", objectArray);
                throw new IllegalArgumentException(string.toString());
            }
            byte[] result2 = new byte[hexText.length() / 2];
            Iterator iterator = SequencesKt.map((Sequence)StringsKt.windowedSequence$default((CharSequence)hexText, (int)2, (int)2, (boolean)false, (int)4, null), Companion::hexToBytes$lambda$1).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                int n2 = ((Number)iterator.next()).intValue();
                result2[index] = (byte)n2;
            }
            return result2;
        }

        private static final int hexToBytes$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Integer.parseInt(it, CharsKt.checkRadix((int)16));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0007\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&\u0082\u0001\u0002\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable;", "", "update", "", "input", "", "finish", "MessageDigestAdapter", "MacAdapter", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable$MacAdapter;", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable$MessageDigestAdapter;", "intellij.httpClient.executor"})
    public static sealed interface DigestBuildable {
        public void update(@NotNull byte[] var1);

        @NotNull
        public byte[] finish();

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable$MacAdapter;", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable;", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljavax/crypto/Mac;)V", "update", "", "input", "", "finish", "intellij.httpClient.executor"})
        public static final class MacAdapter
        implements DigestBuildable {
            @NotNull
            private final Mac mac;

            public MacAdapter(@NotNull Mac mac) {
                Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
                this.mac = mac;
            }

            @Override
            public void update(@NotNull byte[] input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                this.mac.update(input);
            }

            @Override
            @NotNull
            public byte[] finish() {
                byte[] byArray = this.mac.doFinal();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
                return byArray;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable$MessageDigestAdapter;", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable;", "messageDigest", "Ljava/security/MessageDigest;", "<init>", "(Ljava/security/MessageDigest;)V", "update", "", "input", "", "finish", "intellij.httpClient.executor"})
        public static final class MessageDigestAdapter
        implements DigestBuildable {
            @NotNull
            private final MessageDigest messageDigest;

            public MessageDigestAdapter(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                this.messageDigest = messageDigest;
            }

            @Override
            public void update(@NotNull byte[] input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                this.messageDigest.update(input);
            }

            @Override
            @NotNull
            public byte[] finish() {
                byte[] byArray = this.messageDigest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                return byArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuilder;", "", "digestBuildable", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable;", "<init>", "(Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuildable;)V", "updateWithText", "text", "", "encoding", "updateWithHex", "hexText", "updateWithBase64", "base64Text", "urlEncoded", "", "digest", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestHolder;", "intellij.httpClient.executor"})
    public static final class DigestBuilder {
        @NotNull
        private final DigestBuildable digestBuildable;

        public DigestBuilder(@NotNull DigestBuildable digestBuildable) {
            Intrinsics.checkNotNullParameter((Object)digestBuildable, (String)"digestBuildable");
            this.digestBuildable = digestBuildable;
        }

        @NotNull
        public final DigestBuilder updateWithText(@NotNull String text2, @Nullable String encoding) {
            DigestBuilder digestBuilder;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            DigestBuilder it = digestBuilder = this;
            boolean bl = false;
            Charset charset = Companion.findCharset(encoding);
            byte[] byArray = text2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.digestBuildable.update(byArray);
            return digestBuilder;
        }

        public static /* synthetic */ DigestBuilder updateWithText$default(DigestBuilder digestBuilder, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return digestBuilder.updateWithText(string, string2);
        }

        @NotNull
        public final DigestBuilder updateWithHex(@NotNull String hexText) {
            DigestBuilder digestBuilder;
            Intrinsics.checkNotNullParameter((Object)hexText, (String)"hexText");
            DigestBuilder it = digestBuilder = this;
            boolean bl = false;
            byte[] result2 = Companion.hexToBytes(hexText);
            this.digestBuildable.update(result2);
            return digestBuilder;
        }

        @NotNull
        public final DigestBuilder updateWithBase64(@NotNull String base64Text, boolean urlEncoded) {
            DigestBuilder digestBuilder;
            Intrinsics.checkNotNullParameter((Object)base64Text, (String)"base64Text");
            DigestBuilder it = digestBuilder = this;
            boolean bl = false;
            byte[] byArray = (urlEncoded ? Base64.getUrlDecoder() : Base64.getDecoder()).decode(base64Text);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            this.digestBuildable.update(byArray);
            return digestBuilder;
        }

        public static /* synthetic */ DigestBuilder updateWithBase64$default(DigestBuilder digestBuilder, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return digestBuilder.updateWithBase64(string, bl);
        }

        @NotNull
        public final DigestHolder digest() {
            return new DigestHolder(this.digestBuildable.finish());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestHolder;", "", "digest", "", "<init>", "([B)V", "toBase64", "", "urlSafe", "", "toHex", "intellij.httpClient.executor"})
    public static final class DigestHolder {
        @NotNull
        private final byte[] digest;

        public DigestHolder(@NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.digest = digest;
        }

        @NotNull
        public final String toBase64(boolean urlSafe) {
            String string = (urlSafe ? Base64.getUrlEncoder().withoutPadding() : Base64.getEncoder()).encodeToString(this.digest);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }

        public static /* synthetic */ String toBase64$default(DigestHolder digestHolder, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return digestHolder.toBase64(bl);
        }

        @NotNull
        public final String toHex() {
            StringBuilder stringBuilder;
            StringBuilder $this$toHex_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            byte[] byArray = this.digest;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by;
                byte byteAsInt = by = byArray[i];
                $this$toHex_u24lambda_u240.append(((Character)HttpClientPreScriptCryptoSupportKt.access$getHexDigits$p().get((byteAsInt & 0xF0) >>> 4)).charValue());
                $this$toHex_u24lambda_u240.append(((Character)HttpClientPreScriptCryptoSupportKt.access$getHexDigits$p().get(byteAsInt & 0xF)).charValue());
            }
            return stringBuilder.toString();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$HmacInitializer;", "", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljavax/crypto/Mac;)V", "withTextSecret", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$DigestBuilder;", "text", "", "encoding", "withHexSecret", "hex", "withBase64Secret", "base64Text", "urlSafe", "", "withBytesSecret", "bytes", "", "intellij.httpClient.executor"})
    public static final class HmacInitializer {
        @NotNull
        private final Mac mac;

        public HmacInitializer(@NotNull Mac mac) {
            Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
            this.mac = mac;
        }

        @NotNull
        public final DigestBuilder withTextSecret(@NotNull String text2, @Nullable String encoding) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Charset charset = Companion.findCharset(encoding);
            byte[] byArray = text2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.withBytesSecret(byArray);
        }

        public static /* synthetic */ DigestBuilder withTextSecret$default(HmacInitializer hmacInitializer, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return hmacInitializer.withTextSecret(string, string2);
        }

        @NotNull
        public final DigestBuilder withHexSecret(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            return this.withBytesSecret(Companion.hexToBytes(hex));
        }

        @NotNull
        public final DigestBuilder withBase64Secret(@NotNull String base64Text, boolean urlSafe) {
            Intrinsics.checkNotNullParameter((Object)base64Text, (String)"base64Text");
            byte[] bytes = (urlSafe ? Base64.getUrlDecoder() : Base64.getDecoder()).decode(base64Text);
            Intrinsics.checkNotNull((Object)bytes);
            return this.withBytesSecret(bytes);
        }

        private final DigestBuilder withBytesSecret(byte[] bytes) {
            SecretKeySpec keySpec = new SecretKeySpec(bytes, this.mac.getAlgorithm());
            this.mac.init(keySpec);
            return new DigestBuilder(new DigestBuildable.MacAdapter(this.mac));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$HmacSupport;", "", "<init>", "()V", "sha1", "Lcom/intellij/httpClient/http/request/run/preScript/HttpClientPreScriptCryptoSupport$HmacInitializer;", "sha3", "bits", "", "sha256", "sha512", "sha384", "md5", "intellij.httpClient.executor"})
    public static final class HmacSupport {
        @NotNull
        public final HmacInitializer sha1() {
            Mac mac = Mac.getInstance(HttpClientPreScriptCryptoSupport.HMAC_SHA_1);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }

        @NotNull
        public final HmacInitializer sha3(@NotNull String bits) {
            Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
            Mac mac = Mac.getInstance("HmacSHA3-" + bits);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }

        @NotNull
        public final HmacInitializer sha256() {
            Mac mac = Mac.getInstance(HttpClientPreScriptCryptoSupport.HMAC_SHA_256);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }

        @NotNull
        public final HmacInitializer sha512() {
            Mac mac = Mac.getInstance(HttpClientPreScriptCryptoSupport.HMAC_SHA_512);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }

        @NotNull
        public final HmacInitializer sha384() {
            Mac mac = Mac.getInstance(HttpClientPreScriptCryptoSupport.HMAC_SHA_384);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }

        @NotNull
        public final HmacInitializer md5() {
            Mac mac = Mac.getInstance(HttpClientPreScriptCryptoSupport.HMAC_MD5);
            Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
            return new HmacInitializer(mac);
        }
    }
}

