/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.json;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.EscapeUtilsKt;
import com.intellij.json.JsonSpellcheckerStrategy;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/grazie/ide/language/json/JsonTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "<init>", "()V", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "element", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "intellij.grazie.json"})
public final class JsonTextExtractor
extends TextExtractor {
    @Override
    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        if (element instanceof PsiComment || element instanceof JsonStringLiteral) {
            TextContent.TextDomain domain;
            TextContent.TextDomain textDomain = domain = element instanceof PsiComment ? TextContent.TextDomain.COMMENTS : TextContent.TextDomain.LITERALS;
            if (!allowedDomains.contains((Object)domain)) {
                return null;
            }
            if (element instanceof JsonStringLiteral && new JsonSpellcheckerStrategy.JsonSchemaSpellcheckerClientForJson((JsonStringLiteral)element).matchesNameFromSchema()) {
                return null;
            }
            TextContent textContent = TextContentBuilder.FromPsi.build(element, domain);
            if (textContent == null) {
                return null;
            }
            TextContent content = textContent;
            return EscapeUtilsKt.replaceBackslashEscapes(content);
        }
        return null;
    }
}

