/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsFileType;
import com.jetbrains.python.requirements.RequirementsLanguage;
import com.jetbrains.python.requirements.psi.EditableReq;
import com.jetbrains.python.requirements.psi.Option;
import com.jetbrains.python.requirements.psi.ReferReq;
import com.jetbrains.python.requirements.psi.Requirement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/requirements/RequirementsFile;", "Lcom/intellij/extapi/psi/PsiFileBase;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "<init>", "(Lcom/intellij/psi/FileViewProvider;)V", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "requirements", "", "Lcom/jetbrains/python/requirements/psi/Requirement;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "toString", "", "intellij.python.community.impl"})
public final class RequirementsFile
extends PsiFileBase {
    public RequirementsFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        super(viewProvider, (Language)RequirementsLanguage.Companion.getINSTANCE());
    }

    @NotNull
    public FileType getFileType() {
        return (FileType)RequirementsFileType.Companion.getINSTANCE();
    }

    @NotNull
    public final List<Requirement> requirements() {
        List requirements = new ArrayList();
        PsiElement[] psiElementArray = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement child : psiElementArray) {
            if (child instanceof Requirement) {
                requirements.add(child);
                continue;
            }
            if (!(child instanceof Option)) continue;
            EditableReq editableReq = ((Option)child).getEditableReq();
            ReferReq referReq = ((Option)child).getReferReq();
            if (editableReq != null) {
                requirements.add(editableReq);
                continue;
            }
            if (referReq == null) continue;
            requirements.add(referReq);
        }
        return requirements;
    }

    @Nullable
    public final Sdk getSdk() {
        return PackageUtilsKt.getPythonSdk((PsiFile)this);
    }

    @NotNull
    public String toString() {
        return "Requirements File";
    }
}

