/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.ModificationTracker;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelegatingPersistentStateComponent
implements PersistentStateComponent<Element> {
    @NotNull
    private static final Element EMPTY_STATE = JDOMInterner.INSTANCE.internElement(new Element("empty"));
    private Element myState = EMPTY_STATE;
    private long myStateVersion;
    private StateDelegate myStateDelegate;

    public void loadState(@NotNull Element state) {
        StateDelegate delegate;
        if (state == null) {
            DelegatingPersistentStateComponent.$$$reportNull$$$0(0);
        }
        if (this.storeState(state, Integer.MIN_VALUE) && (delegate = this.myStateDelegate) != null) {
            delegate.onExternalChange();
        }
    }

    public void noStateLoaded() {
        this.loadState(EMPTY_STATE);
    }

    public void setStateDelegate(@Nullable StateDelegate stateDelegate) {
        this.myStateDelegate = stateDelegate;
    }

    public Element getState() {
        long version;
        StateDelegate delegate = this.myStateDelegate;
        if (delegate != null && (version = delegate.getModificationCount()) != this.myStateVersion) {
            this.storeState(delegate.getState(), version);
        }
        return this.getStoredState();
    }

    public Element getStoredState() {
        return this.myState;
    }

    public boolean storeState(@Nullable Element state, long stateVersion) {
        Element newState;
        Element element = newState = state == null ? null : JDOMInterner.INSTANCE.internElement(state);
        if (this.myState == newState && stateVersion == Integer.MIN_VALUE) {
            return false;
        }
        this.myState = newState;
        this.myStateVersion = stateVersion;
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DelegatingPersistentStateComponent", "loadState"));
    }

    static interface StateDelegate
    extends ModificationTracker {
        @NotNull
        public Element getState();

        public void onExternalChange();
    }
}

