// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::subscribe_to_shard::_subscribe_to_shard_output::SubscribeToShardOutputBuilder;

pub use crate::operation::subscribe_to_shard::_subscribe_to_shard_input::SubscribeToShardInputBuilder;

impl crate::operation::subscribe_to_shard::builders::SubscribeToShardInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::subscribe_to_shard::SubscribeToShardOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::subscribe_to_shard::SubscribeToShardError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.subscribe_to_shard();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `SubscribeToShard`.
///
/// <p>This operation establishes an HTTP/2 connection between the consumer you specify in the <code>ConsumerARN</code> parameter and the shard you specify in the <code>ShardId</code> parameter. After the connection is successfully established, Kinesis Data Streams pushes records from the shard to the consumer over this connection. Before you call this operation, call <code>RegisterStreamConsumer</code> to register the consumer with Kinesis Data Streams.</p>
/// <p>When the <code>SubscribeToShard</code> call succeeds, your consumer starts receiving events of type <code>SubscribeToShardEvent</code> over the HTTP/2 connection for up to 5 minutes, after which time you need to call <code>SubscribeToShard</code> again to renew the subscription if you want to continue to receive records.</p>
/// <p>You can make one call to <code>SubscribeToShard</code> per second per registered consumer per shard. For example, if you have a 4000 shard stream and two registered stream consumers, you can make one <code>SubscribeToShard</code> request per second for each combination of shard and registered consumer, allowing you to subscribe both consumers to all 4000 shards in one second.</p>
/// <p>If you call <code>SubscribeToShard</code> again with the same <code>ConsumerARN</code> and <code>ShardId</code> within 5 seconds of a successful call, you'll get a <code>ResourceInUseException</code>. If you call <code>SubscribeToShard</code> 5 seconds or more after a successful call, the second call takes over the subscription and the previous connection expires or fails with a <code>ResourceInUseException</code>.</p>
/// <p>For an example of how to use this operation, see <a href="https://docs.aws.amazon.com/streams/latest/dev/building-enhanced-consumers-api.html">Enhanced Fan-Out Using the Kinesis Data Streams API</a>.</p>
///
/// [`SubscribeToShardOutput`](crate::operation::subscribe_to_shard::SubscribeToShardOutput) contains an event stream field as well as one or more non-event stream fields.
/// Due to its current implementation, the non-event stream fields are not fully deserialized
/// until the [`send`](Self::send) method completes. As a result, accessing these fields of the operation
/// output struct within an interceptor may return uninitialized values.
///
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct SubscribeToShardFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::subscribe_to_shard::builders::SubscribeToShardInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::subscribe_to_shard::SubscribeToShardOutput,
        crate::operation::subscribe_to_shard::SubscribeToShardError,
    > for SubscribeToShardFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::subscribe_to_shard::SubscribeToShardOutput,
            crate::operation::subscribe_to_shard::SubscribeToShardError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl SubscribeToShardFluentBuilder {
    /// Creates a new `SubscribeToShardFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the SubscribeToShard as a reference.
    pub fn as_input(&self) -> &crate::operation::subscribe_to_shard::builders::SubscribeToShardInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::subscribe_to_shard::SubscribeToShardOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::subscribe_to_shard::SubscribeToShardError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::subscribe_to_shard::SubscribeToShard::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        let mut output = crate::operation::subscribe_to_shard::SubscribeToShard::orchestrate(&runtime_plugins, input).await?;

        // Converts any error encountered beyond this point into an `SdkError` response error
        // with an `HttpResponse`. However, since we have already exited the `orchestrate`
        // function, the original `HttpResponse` is no longer available and cannot be restored.
        // This means that header information from the original response has been lost.
        //
        // Note that the response body would have been consumed by the deserializer
        // regardless, even if the initial message was hypothetically processed during
        // the orchestrator's deserialization phase but later resulted in an error.
        fn response_error(
            err: impl ::std::convert::Into<::aws_smithy_runtime_api::box_error::BoxError>,
        ) -> ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::subscribe_to_shard::SubscribeToShardError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        > {
            ::aws_smithy_runtime_api::client::result::SdkError::response_error(
                err,
                ::aws_smithy_runtime_api::client::orchestrator::HttpResponse::new(
                    ::aws_smithy_runtime_api::http::StatusCode::try_from(200).expect("valid successful code"),
                    ::aws_smithy_types::body::SdkBody::empty(),
                ),
            )
        }

        let message = output.event_stream.try_recv_initial_response().await.map_err(response_error)?;

        match message {
            ::std::option::Option::Some(_message) => ::std::result::Result::Ok(output),
            ::std::option::Option::None => ::std::result::Result::Ok(output),
        }
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::subscribe_to_shard::SubscribeToShardOutput,
        crate::operation::subscribe_to_shard::SubscribeToShardError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>For this parameter, use the value you obtained when you called <code>RegisterStreamConsumer</code>.</p>
    pub fn consumer_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.consumer_arn(input.into());
        self
    }
    /// <p>For this parameter, use the value you obtained when you called <code>RegisterStreamConsumer</code>.</p>
    pub fn set_consumer_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_consumer_arn(input);
        self
    }
    /// <p>For this parameter, use the value you obtained when you called <code>RegisterStreamConsumer</code>.</p>
    pub fn get_consumer_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_consumer_arn()
    }
    /// <p>The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use <code>ListShards</code>.</p>
    pub fn shard_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.shard_id(input.into());
        self
    }
    /// <p>The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use <code>ListShards</code>.</p>
    pub fn set_shard_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_shard_id(input);
        self
    }
    /// <p>The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use <code>ListShards</code>.</p>
    pub fn get_shard_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_shard_id()
    }
    /// <p>The starting position in the data stream from which to start streaming.</p>
    pub fn starting_position(mut self, input: crate::types::StartingPosition) -> Self {
        self.inner = self.inner.starting_position(input);
        self
    }
    /// <p>The starting position in the data stream from which to start streaming.</p>
    pub fn set_starting_position(mut self, input: ::std::option::Option<crate::types::StartingPosition>) -> Self {
        self.inner = self.inner.set_starting_position(input);
        self
    }
    /// <p>The starting position in the data stream from which to start streaming.</p>
    pub fn get_starting_position(&self) -> &::std::option::Option<crate::types::StartingPosition> {
        self.inner.get_starting_position()
    }
}
