package notificationhubs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/notificationhubs/mgmt/2017-04-01/notificationhubs"

// AdmCredential description of a NotificationHub AdmCredential.
type AdmCredential struct {
	// AdmCredentialProperties - Properties of NotificationHub AdmCredential.
	*AdmCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AdmCredential.
func (ac AdmCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.AdmCredentialProperties != nil {
		objectMap["properties"] = ac.AdmCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdmCredential struct.
func (ac *AdmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var admCredentialProperties AdmCredentialProperties
				err = json.Unmarshal(*v, &admCredentialProperties)
				if err != nil {
					return err
				}
				ac.AdmCredentialProperties = &admCredentialProperties
			}
		}
	}

	return nil
}

// AdmCredentialProperties description of a NotificationHub AdmCredential.
type AdmCredentialProperties struct {
	// ClientID - The client identifier.
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The credential secret access key.
	ClientSecret *string `json:"clientSecret,omitempty"`
	// AuthTokenURL - The URL of the authorization token.
	AuthTokenURL *string `json:"authTokenUrl,omitempty"`
}

// ApnsCredential description of a NotificationHub ApnsCredential.
type ApnsCredential struct {
	// ApnsCredentialProperties - Properties of NotificationHub ApnsCredential.
	*ApnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApnsCredential.
func (ac ApnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.ApnsCredentialProperties != nil {
		objectMap["properties"] = ac.ApnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApnsCredential struct.
func (ac *ApnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var apnsCredentialProperties ApnsCredentialProperties
				err = json.Unmarshal(*v, &apnsCredentialProperties)
				if err != nil {
					return err
				}
				ac.ApnsCredentialProperties = &apnsCredentialProperties
			}
		}
	}

	return nil
}

// ApnsCredentialProperties description of a NotificationHub ApnsCredential. Note that there is no explicit
// switch between Certificate and Token Authentication Modes. The mode is determined based on the
// properties passed in.
type ApnsCredentialProperties struct {
	// ApnsCertificate - The APNS certificate. Specify if using Certificate Authentication Mode.
	ApnsCertificate *string `json:"apnsCertificate,omitempty"`
	// CertificateKey - The APNS certificate password if it exists.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Endpoint - The APNS endpoint of this credential. If using Certificate Authentication Mode and Sandbox specify 'gateway.sandbox.push.apple.com'. If using Certificate Authentication Mode and Production specify 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox specify 'https://api.development.push.apple.com:443/3/device'. If using Token Authentication Mode and Production specify 'https://api.push.apple.com:443/3/device'.
	Endpoint *string `json:"endpoint,omitempty"`
	// Thumbprint - The APNS certificate thumbprint. Specify if using Certificate Authentication Mode.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// KeyID - A 10-character key identifier (kid) key, obtained from your developer account. Specify if using Token Authentication Mode.
	KeyID *string `json:"keyId,omitempty"`
	// AppName - The name of the application or BundleId. Specify if using Token Authentication Mode.
	AppName *string `json:"appName,omitempty"`
	// AppID - The issuer (iss) registered claim key. The value is a 10-character TeamId, obtained from your developer account. Specify if using Token Authentication Mode.
	AppID *string `json:"appId,omitempty"`
	// Token - Provider Authentication Token, obtained through your developer account. Specify if using Token Authentication Mode.
	Token *string `json:"token,omitempty"`
}

// BaiduCredential description of a NotificationHub BaiduCredential.
type BaiduCredential struct {
	// BaiduCredentialProperties - Properties of NotificationHub BaiduCredential.
	*BaiduCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BaiduCredential.
func (bc BaiduCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bc.BaiduCredentialProperties != nil {
		objectMap["properties"] = bc.BaiduCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BaiduCredential struct.
func (bc *BaiduCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var baiduCredentialProperties BaiduCredentialProperties
				err = json.Unmarshal(*v, &baiduCredentialProperties)
				if err != nil {
					return err
				}
				bc.BaiduCredentialProperties = &baiduCredentialProperties
			}
		}
	}

	return nil
}

// BaiduCredentialProperties description of a NotificationHub BaiduCredential.
type BaiduCredentialProperties struct {
	// BaiduAPIKey - Baidu Api Key.
	BaiduAPIKey *string `json:"baiduApiKey,omitempty"`
	// BaiduEndPoint - Baidu Endpoint.
	BaiduEndPoint *string `json:"baiduEndPoint,omitempty"`
	// BaiduSecretKey - Baidu Secret Key
	BaiduSecretKey *string `json:"baiduSecretKey,omitempty"`
}

// CheckAvailabilityParameters parameters supplied to the Check Name Availability for Namespace and
// NotificationHubs.
type CheckAvailabilityParameters struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckAvailabilityParameters.
func (capVar CheckAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if capVar.Name != nil {
		objectMap["name"] = capVar.Name
	}
	if capVar.Location != nil {
		objectMap["location"] = capVar.Location
	}
	if capVar.Tags != nil {
		objectMap["tags"] = capVar.Tags
	}
	if capVar.Sku != nil {
		objectMap["sku"] = capVar.Sku
	}
	if capVar.IsAvailiable != nil {
		objectMap["isAvailiable"] = capVar.IsAvailiable
	}
	return json.Marshal(objectMap)
}

// CheckAvailabilityResult description of a CheckAvailability resource.
type CheckAvailabilityResult struct {
	autorest.Response `json:"-"`
	// IsAvailiable - True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool `json:"isAvailiable,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckAvailabilityResult.
func (car CheckAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if car.IsAvailiable != nil {
		objectMap["isAvailiable"] = car.IsAvailiable
	}
	if car.Location != nil {
		objectMap["location"] = car.Location
	}
	if car.Tags != nil {
		objectMap["tags"] = car.Tags
	}
	if car.Sku != nil {
		objectMap["sku"] = car.Sku
	}
	return json.Marshal(objectMap)
}

// CreateOrUpdateParameters parameters supplied to the CreateOrUpdate NotificationHub operation.
type CreateOrUpdateParameters struct {
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrUpdateParameters.
func (coup CreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coup.Properties != nil {
		objectMap["properties"] = coup.Properties
	}
	if coup.Location != nil {
		objectMap["location"] = coup.Location
	}
	if coup.Tags != nil {
		objectMap["tags"] = coup.Tags
	}
	if coup.Sku != nil {
		objectMap["sku"] = coup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CreateOrUpdateParameters struct.
func (coup *CreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				coup.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				coup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				coup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				coup.Sku = &sku
			}
		}
	}

	return nil
}

// DebugSendResponse description of a NotificationHub Resource.
type DebugSendResponse struct {
	autorest.Response `json:"-"`
	// DebugSendResult - Properties of the NotificationHub.
	*DebugSendResult `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for DebugSendResponse.
func (dsr DebugSendResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsr.DebugSendResult != nil {
		objectMap["properties"] = dsr.DebugSendResult
	}
	if dsr.Location != nil {
		objectMap["location"] = dsr.Location
	}
	if dsr.Tags != nil {
		objectMap["tags"] = dsr.Tags
	}
	if dsr.Sku != nil {
		objectMap["sku"] = dsr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DebugSendResponse struct.
func (dsr *DebugSendResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var debugSendResult DebugSendResult
				err = json.Unmarshal(*v, &debugSendResult)
				if err != nil {
					return err
				}
				dsr.DebugSendResult = &debugSendResult
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dsr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dsr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				dsr.Sku = &sku
			}
		}
	}

	return nil
}

// DebugSendResult ...
type DebugSendResult struct {
	// Success - successful send
	Success *float64 `json:"success,omitempty"`
	// Failure - send failure
	Failure *float64 `json:"failure,omitempty"`
	// Results - actual failure description
	Results interface{} `json:"results,omitempty"`
}

// ErrorResponse error response indicates NotificationHubs service is not able to process the incoming
// request. The reason is provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GcmCredential description of a NotificationHub GcmCredential.
type GcmCredential struct {
	// GcmCredentialProperties - Properties of NotificationHub GcmCredential.
	*GcmCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GcmCredential.
func (gc GcmCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gc.GcmCredentialProperties != nil {
		objectMap["properties"] = gc.GcmCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GcmCredential struct.
func (gc *GcmCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gcmCredentialProperties GcmCredentialProperties
				err = json.Unmarshal(*v, &gcmCredentialProperties)
				if err != nil {
					return err
				}
				gc.GcmCredentialProperties = &gcmCredentialProperties
			}
		}
	}

	return nil
}

// GcmCredentialProperties description of a NotificationHub GcmCredential.
type GcmCredentialProperties struct {
	// GcmEndpoint - The FCM legacy endpoint. Default value is 'https://fcm.googleapis.com/fcm/send'
	GcmEndpoint *string `json:"gcmEndpoint,omitempty"`
	// GoogleAPIKey - The Google API key.
	GoogleAPIKey *string `json:"googleApiKey,omitempty"`
}

// ListResult the response of the List NotificationHub operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List NotificationHub operation.
	Value *[]ResourceType `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of NotificationHub
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ResourceType values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ResourceType {
	if !iter.page.NotDone() {
		return ResourceType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ResourceType values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ResourceType {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// MpnsCredential description of a NotificationHub MpnsCredential.
type MpnsCredential struct {
	// MpnsCredentialProperties - Properties of NotificationHub MpnsCredential.
	*MpnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MpnsCredential.
func (mc MpnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.MpnsCredentialProperties != nil {
		objectMap["properties"] = mc.MpnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MpnsCredential struct.
func (mc *MpnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mpnsCredentialProperties MpnsCredentialProperties
				err = json.Unmarshal(*v, &mpnsCredentialProperties)
				if err != nil {
					return err
				}
				mc.MpnsCredentialProperties = &mpnsCredentialProperties
			}
		}
	}

	return nil
}

// MpnsCredentialProperties description of a NotificationHub MpnsCredential.
type MpnsCredentialProperties struct {
	// MpnsCertificate - The MPNS certificate.
	MpnsCertificate *string `json:"mpnsCertificate,omitempty"`
	// CertificateKey - The certificate key for this credential.
	CertificateKey *string `json:"certificateKey,omitempty"`
	// Thumbprint - The MPNS certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// NamespaceCreateOrUpdateParameters parameters supplied to the CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceCreateOrUpdateParameters.
func (ncoup NamespaceCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ncoup.NamespaceProperties != nil {
		objectMap["properties"] = ncoup.NamespaceProperties
	}
	if ncoup.Location != nil {
		objectMap["location"] = ncoup.Location
	}
	if ncoup.Tags != nil {
		objectMap["tags"] = ncoup.Tags
	}
	if ncoup.Sku != nil {
		objectMap["sku"] = ncoup.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceCreateOrUpdateParameters struct.
func (ncoup *NamespaceCreateOrUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				ncoup.NamespaceProperties = &namespaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ncoup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ncoup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ncoup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ncoup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ncoup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ncoup.Sku = &sku
			}
		}
	}

	return nil
}

// NamespaceListResult the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List Namespace operation.
	Value *[]NamespaceResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string `json:"nextLink,omitempty"`
}

// NamespaceListResultIterator provides access to a complete listing of NamespaceResource values.
type NamespaceListResultIterator struct {
	i    int
	page NamespaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NamespaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NamespaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NamespaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NamespaceListResultIterator) Response() NamespaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NamespaceListResultIterator) Value() NamespaceResource {
	if !iter.page.NotDone() {
		return NamespaceResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NamespaceListResultIterator type.
func NewNamespaceListResultIterator(page NamespaceListResultPage) NamespaceListResultIterator {
	return NamespaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nlr NamespaceListResult) IsEmpty() bool {
	return nlr.Value == nil || len(*nlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nlr NamespaceListResult) hasNextLink() bool {
	return nlr.NextLink != nil && len(*nlr.NextLink) != 0
}

// namespaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nlr NamespaceListResult) namespaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !nlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nlr.NextLink)))
}

// NamespaceListResultPage contains a page of NamespaceResource values.
type NamespaceListResultPage struct {
	fn  func(context.Context, NamespaceListResult) (NamespaceListResult, error)
	nlr NamespaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NamespaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NamespaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nlr)
		if err != nil {
			return err
		}
		page.nlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NamespaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NamespaceListResultPage) NotDone() bool {
	return !page.nlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NamespaceListResultPage) Response() NamespaceListResult {
	return page.nlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NamespaceListResultPage) Values() []NamespaceResource {
	if page.nlr.IsEmpty() {
		return nil
	}
	return *page.nlr.Value
}

// Creates a new instance of the NamespaceListResultPage type.
func NewNamespaceListResultPage(cur NamespaceListResult, getNextPage func(context.Context, NamespaceListResult) (NamespaceListResult, error)) NamespaceListResultPage {
	return NamespaceListResultPage{
		fn:  getNextPage,
		nlr: cur,
	}
}

// NamespacePatchParameters parameters supplied to the Patch Namespace operation.
type NamespacePatchParameters struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespacePatchParameters.
func (npp NamespacePatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if npp.Tags != nil {
		objectMap["tags"] = npp.Tags
	}
	if npp.Sku != nil {
		objectMap["sku"] = npp.Sku
	}
	return json.Marshal(objectMap)
}

// NamespaceProperties namespace properties.
type NamespaceProperties struct {
	// Name - The name of the namespace.
	Name *string `json:"name,omitempty"`
	// ProvisioningState - Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Region - Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia East, Australia Southeast, Central US, East US, East US 2, West US, North Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
	Region *string `json:"region,omitempty"`
	// MetricID - READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string `json:"metricId,omitempty"`
	// Status - Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
	Status *string `json:"status,omitempty"`
	// CreatedAt - The time the namespace was created.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// UpdatedAt - The time the namespace was updated.
	UpdatedAt *date.Time `json:"updatedAt,omitempty"`
	// ServiceBusEndpoint - Endpoint you can use to perform NotificationHub operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty"`
	// SubscriptionID - The Id of the Azure subscription associated with the namespace.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ScaleUnit - ScaleUnit where the namespace gets created
	ScaleUnit *string `json:"scaleUnit,omitempty"`
	// Enabled - Whether or not the namespace is currently enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Critical - Whether or not the namespace is set as Critical.
	Critical *bool `json:"critical,omitempty"`
	// DataCenter - Data center for the namespace
	DataCenter *string `json:"dataCenter,omitempty"`
	// NamespaceType - The namespace type. Possible values include: 'Messaging', 'NotificationHub'
	NamespaceType NamespaceType `json:"namespaceType,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceProperties.
func (np NamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if np.Name != nil {
		objectMap["name"] = np.Name
	}
	if np.ProvisioningState != nil {
		objectMap["provisioningState"] = np.ProvisioningState
	}
	if np.Region != nil {
		objectMap["region"] = np.Region
	}
	if np.Status != nil {
		objectMap["status"] = np.Status
	}
	if np.CreatedAt != nil {
		objectMap["createdAt"] = np.CreatedAt
	}
	if np.UpdatedAt != nil {
		objectMap["updatedAt"] = np.UpdatedAt
	}
	if np.ServiceBusEndpoint != nil {
		objectMap["serviceBusEndpoint"] = np.ServiceBusEndpoint
	}
	if np.SubscriptionID != nil {
		objectMap["subscriptionId"] = np.SubscriptionID
	}
	if np.ScaleUnit != nil {
		objectMap["scaleUnit"] = np.ScaleUnit
	}
	if np.Enabled != nil {
		objectMap["enabled"] = np.Enabled
	}
	if np.Critical != nil {
		objectMap["critical"] = np.Critical
	}
	if np.DataCenter != nil {
		objectMap["dataCenter"] = np.DataCenter
	}
	if np.NamespaceType != "" {
		objectMap["namespaceType"] = np.NamespaceType
	}
	return json.Marshal(objectMap)
}

// NamespaceResource description of a Namespace resource.
type NamespaceResource struct {
	autorest.Response `json:"-"`
	// NamespaceProperties - Properties of the Namespace.
	*NamespaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for NamespaceResource.
func (nr NamespaceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nr.NamespaceProperties != nil {
		objectMap["properties"] = nr.NamespaceProperties
	}
	if nr.Location != nil {
		objectMap["location"] = nr.Location
	}
	if nr.Tags != nil {
		objectMap["tags"] = nr.Tags
	}
	if nr.Sku != nil {
		objectMap["sku"] = nr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NamespaceResource struct.
func (nr *NamespaceResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var namespaceProperties NamespaceProperties
				err = json.Unmarshal(*v, &namespaceProperties)
				if err != nil {
					return err
				}
				nr.NamespaceProperties = &namespaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				nr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				nr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				nr.Sku = &sku
			}
		}
	}

	return nil
}

// NamespacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NamespacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NamespacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NamespacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NamespacesDeleteFuture.Result.
func (future *NamespacesDeleteFuture) result(client NamespacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "notificationhubs.NamespacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("notificationhubs.NamespacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Operation a NotificationHubs REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.NotificationHubs
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of the request to list NotificationHubs operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of NotificationHubs operations supported by the Microsoft.NotificationHubs resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PatchParameters parameters supplied to the patch NotificationHub operation.
type PatchParameters struct {
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchParameters.
func (pp PatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Properties != nil {
		objectMap["properties"] = pp.Properties
	}
	if pp.Location != nil {
		objectMap["location"] = pp.Location
	}
	if pp.Tags != nil {
		objectMap["tags"] = pp.Tags
	}
	if pp.Sku != nil {
		objectMap["sku"] = pp.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PatchParameters struct.
func (pp *PatchParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				pp.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pp.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pp.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pp.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pp.Sku = &sku
			}
		}
	}

	return nil
}

// PnsCredentialsProperties description of a NotificationHub PNS Credentials.
type PnsCredentialsProperties struct {
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// PnsCredentialsResource description of a NotificationHub PNS Credentials.
type PnsCredentialsResource struct {
	autorest.Response `json:"-"`
	// PnsCredentialsProperties - NotificationHub PNS Credentials.
	*PnsCredentialsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for PnsCredentialsResource.
func (pcr PnsCredentialsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcr.PnsCredentialsProperties != nil {
		objectMap["properties"] = pcr.PnsCredentialsProperties
	}
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.Sku != nil {
		objectMap["sku"] = pcr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PnsCredentialsResource struct.
func (pcr *PnsCredentialsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pnsCredentialsProperties PnsCredentialsProperties
				err = json.Unmarshal(*v, &pnsCredentialsProperties)
				if err != nil {
					return err
				}
				pcr.PnsCredentialsProperties = &pnsCredentialsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				pcr.Sku = &sku
			}
		}
	}

	return nil
}

// PolicykeyResource namespace/NotificationHub Regenerate Keys
type PolicykeyResource struct {
	// PolicyKey - Name of the key that has to be regenerated for the Namespace/Notification Hub Authorization Rule. The value can be Primary Key/Secondary Key.
	PolicyKey *string `json:"policyKey,omitempty"`
}

// Properties notificationHub properties.
type Properties struct {
	// Name - The NotificationHub name.
	Name *string `json:"name,omitempty"`
	// RegistrationTTL - The RegistrationTtl of the created NotificationHub
	RegistrationTTL *string `json:"registrationTtl,omitempty"`
	// AuthorizationRules - The AuthorizationRules of the created NotificationHub
	AuthorizationRules *[]SharedAccessAuthorizationRuleProperties `json:"authorizationRules,omitempty"`
	// ApnsCredential - The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential `json:"apnsCredential,omitempty"`
	// WnsCredential - The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential `json:"wnsCredential,omitempty"`
	// GcmCredential - The GcmCredential of the created NotificationHub
	GcmCredential *GcmCredential `json:"gcmCredential,omitempty"`
	// MpnsCredential - The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential `json:"mpnsCredential,omitempty"`
	// AdmCredential - The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential `json:"admCredential,omitempty"`
	// BaiduCredential - The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential `json:"baiduCredential,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	return json.Marshal(objectMap)
}

// ResourceListKeys namespace/NotificationHub Connection String
type ResourceListKeys struct {
	autorest.Response `json:"-"`
	// PrimaryConnectionString - PrimaryConnectionString of the AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - SecondaryConnectionString of the created AuthorizationRule
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// PrimaryKey - PrimaryKey of the created AuthorizationRule.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - SecondaryKey of the created AuthorizationRule
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - KeyName of the created AuthorizationRule
	KeyName *string `json:"keyName,omitempty"`
}

// ResourceType description of a NotificationHub Resource.
type ResourceType struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the NotificationHub.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceType.
func (rt ResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Properties != nil {
		objectMap["properties"] = rt.Properties
	}
	if rt.Location != nil {
		objectMap["location"] = rt.Location
	}
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	if rt.Sku != nil {
		objectMap["sku"] = rt.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceType struct.
func (rt *ResourceType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				rt.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rt.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rt.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rt.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rt.Sku = &sku
			}
		}
	}

	return nil
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters parameters supplied to the CreateOrUpdate
// Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// Properties - Properties of the Namespace AuthorizationRules.
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// SharedAccessAuthorizationRuleListResult the response of the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Result of the List AuthorizationRules operation.
	Value *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessAuthorizationRuleResource values.
type SharedAccessAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessAuthorizationRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessAuthorizationRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessAuthorizationRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SharedAccessAuthorizationRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessAuthorizationRuleListResultIterator) Response() SharedAccessAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessAuthorizationRuleListResultIterator) Value() SharedAccessAuthorizationRuleResource {
	if !iter.page.NotDone() {
		return SharedAccessAuthorizationRuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SharedAccessAuthorizationRuleListResultIterator type.
func NewSharedAccessAuthorizationRuleListResultIterator(page SharedAccessAuthorizationRuleListResultPage) SharedAccessAuthorizationRuleListResultIterator {
	return SharedAccessAuthorizationRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saarlr SharedAccessAuthorizationRuleListResult) IsEmpty() bool {
	return saarlr.Value == nil || len(*saarlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (saarlr SharedAccessAuthorizationRuleListResult) hasNextLink() bool {
	return saarlr.NextLink != nil && len(*saarlr.NextLink) != 0
}

// sharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saarlr SharedAccessAuthorizationRuleListResult) sharedAccessAuthorizationRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !saarlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saarlr.NextLink)))
}

// SharedAccessAuthorizationRuleListResultPage contains a page of SharedAccessAuthorizationRuleResource
// values.
type SharedAccessAuthorizationRuleListResultPage struct {
	fn     func(context.Context, SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)
	saarlr SharedAccessAuthorizationRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessAuthorizationRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SharedAccessAuthorizationRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.saarlr)
		if err != nil {
			return err
		}
		page.saarlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SharedAccessAuthorizationRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessAuthorizationRuleListResultPage) NotDone() bool {
	return !page.saarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessAuthorizationRuleListResultPage) Response() SharedAccessAuthorizationRuleListResult {
	return page.saarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessAuthorizationRuleListResultPage) Values() []SharedAccessAuthorizationRuleResource {
	if page.saarlr.IsEmpty() {
		return nil
	}
	return *page.saarlr.Value
}

// Creates a new instance of the SharedAccessAuthorizationRuleListResultPage type.
func NewSharedAccessAuthorizationRuleListResultPage(cur SharedAccessAuthorizationRuleListResult, getNextPage func(context.Context, SharedAccessAuthorizationRuleListResult) (SharedAccessAuthorizationRuleListResult, error)) SharedAccessAuthorizationRuleListResultPage {
	return SharedAccessAuthorizationRuleListResultPage{
		fn:     getNextPage,
		saarlr: cur,
	}
}

// SharedAccessAuthorizationRuleProperties sharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// Rights - The rights associated with the rule.
	Rights *[]AccessRights `json:"rights,omitempty"`
	// PrimaryKey - READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// KeyName - READ-ONLY; A string that describes the authorization rule.
	KeyName *string `json:"keyName,omitempty"`
	// ClaimType - READ-ONLY; A string that describes the claim type
	ClaimType *string `json:"claimType,omitempty"`
	// ClaimValue - READ-ONLY; A string that describes the claim value
	ClaimValue *string `json:"claimValue,omitempty"`
	// ModifiedTime - READ-ONLY; The last modified time for this rule
	ModifiedTime *string `json:"modifiedTime,omitempty"`
	// CreatedTime - READ-ONLY; The created time for this rule
	CreatedTime *string `json:"createdTime,omitempty"`
	// Revision - READ-ONLY; The revision number for the rule
	Revision *int32 `json:"revision,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleProperties.
func (saarp SharedAccessAuthorizationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarp.Rights != nil {
		objectMap["rights"] = saarp.Rights
	}
	return json.Marshal(objectMap)
}

// SharedAccessAuthorizationRuleResource description of a Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response `json:"-"`
	// SharedAccessAuthorizationRuleProperties - Properties of the Namespace AuthorizationRule.
	*SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Sku - The sku of the created namespace
	Sku *Sku `json:"sku,omitempty"`
}

// MarshalJSON is the custom marshaler for SharedAccessAuthorizationRuleResource.
func (saarr SharedAccessAuthorizationRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saarr.SharedAccessAuthorizationRuleProperties != nil {
		objectMap["properties"] = saarr.SharedAccessAuthorizationRuleProperties
	}
	if saarr.Location != nil {
		objectMap["location"] = saarr.Location
	}
	if saarr.Tags != nil {
		objectMap["tags"] = saarr.Tags
	}
	if saarr.Sku != nil {
		objectMap["sku"] = saarr.Sku
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SharedAccessAuthorizationRuleResource struct.
func (saarr *SharedAccessAuthorizationRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sharedAccessAuthorizationRuleProperties SharedAccessAuthorizationRuleProperties
				err = json.Unmarshal(*v, &sharedAccessAuthorizationRuleProperties)
				if err != nil {
					return err
				}
				saarr.SharedAccessAuthorizationRuleProperties = &sharedAccessAuthorizationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saarr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saarr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saarr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				saarr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				saarr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				saarr.Sku = &sku
			}
		}
	}

	return nil
}

// Sku the Sku description for a namespace
type Sku struct {
	// Name - Name of the notification hub sku. Possible values include: 'Free', 'Basic', 'Standard'
	Name SkuName `json:"name,omitempty"`
	// Tier - The tier of particular sku
	Tier *string `json:"tier,omitempty"`
	// Size - The Sku size
	Size *string `json:"size,omitempty"`
	// Family - The Sku Family
	Family *string `json:"family,omitempty"`
	// Capacity - The capacity of the resource
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubResource ...
type SubResource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
}

// WnsCredential description of a NotificationHub WnsCredential.
type WnsCredential struct {
	// WnsCredentialProperties - Properties of NotificationHub WnsCredential.
	*WnsCredentialProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WnsCredential.
func (wc WnsCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wc.WnsCredentialProperties != nil {
		objectMap["properties"] = wc.WnsCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WnsCredential struct.
func (wc *WnsCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var wnsCredentialProperties WnsCredentialProperties
				err = json.Unmarshal(*v, &wnsCredentialProperties)
				if err != nil {
					return err
				}
				wc.WnsCredentialProperties = &wnsCredentialProperties
			}
		}
	}

	return nil
}

// WnsCredentialProperties description of a NotificationHub WnsCredential.
type WnsCredentialProperties struct {
	// PackageSid - The package ID for this credential.
	PackageSid *string `json:"packageSid,omitempty"`
	// SecretKey - The secret key.
	SecretKey *string `json:"secretKey,omitempty"`
	// WindowsLiveEndpoint - The Windows Live endpoint.
	WindowsLiveEndpoint *string `json:"windowsLiveEndpoint,omitempty"`
}
