package locksapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2015-01-01/locks"
	"github.com/Azure/go-autorest/autorest"
)

// ManagementLocksClientAPI contains the set of methods on the ManagementLocksClient type.
type ManagementLocksClientAPI interface {
	CreateOrUpdateAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	CreateOrUpdateAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	CreateOrUpdateAtSubscriptionLevel(ctx context.Context, lockName string, parameters locks.ManagementLockObject) (result locks.ManagementLockObject, err error)
	DeleteAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result autorest.Response, err error)
	DeleteAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string) (result autorest.Response, err error)
	DeleteAtSubscriptionLevel(ctx context.Context, lockName string) (result autorest.Response, err error)
	Get(ctx context.Context, lockName string) (result locks.ManagementLockObject, err error)
	GetAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string) (result locks.ManagementLockObject, err error)
	ListAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string) (result locks.ManagementLockListResultIterator, err error)
	ListAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtResourceLevelComplete(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, filter string) (result locks.ManagementLockListResultIterator, err error)
	ListAtSubscriptionLevel(ctx context.Context, filter string) (result locks.ManagementLockListResultPage, err error)
	ListAtSubscriptionLevelComplete(ctx context.Context, filter string) (result locks.ManagementLockListResultIterator, err error)
}

var _ ManagementLocksClientAPI = (*locks.ManagementLocksClient)(nil)
