package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAllRegionsStatistics invokes the aegis.DescribeAllRegionsStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describeallregionsstatistics.html
func (client *Client) DescribeAllRegionsStatistics(request *DescribeAllRegionsStatisticsRequest) (response *DescribeAllRegionsStatisticsResponse, err error) {
	response = CreateDescribeAllRegionsStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAllRegionsStatisticsWithChan invokes the aegis.DescribeAllRegionsStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeallregionsstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAllRegionsStatisticsWithChan(request *DescribeAllRegionsStatisticsRequest) (<-chan *DescribeAllRegionsStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeAllRegionsStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAllRegionsStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAllRegionsStatisticsWithCallback invokes the aegis.DescribeAllRegionsStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeallregionsstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAllRegionsStatisticsWithCallback(request *DescribeAllRegionsStatisticsRequest, callback func(response *DescribeAllRegionsStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAllRegionsStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAllRegionsStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAllRegionsStatisticsRequest is the request struct for api DescribeAllRegionsStatistics
type DescribeAllRegionsStatisticsRequest struct {
	*requests.RpcRequest
	StatusList  string           `position:"Query" name:"StatusList"`
	SaleId      string           `position:"Query" name:"SaleId"`
	RuleType    requests.Integer `position:"Query" name:"RuleType"`
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	EndTime     string           `position:"Query" name:"EndTime"`
	Remark      string           `position:"Query" name:"Remark"`
	Dealed      string           `position:"Query" name:"Dealed"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   string           `position:"Query" name:"StartTime"`
	Type        string           `position:"Query" name:"Type"`
	Uuid        string           `position:"Query" name:"Uuid"`
	SecureToken string           `position:"Query" name:"SecureToken"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	WebGroupId  requests.Integer `position:"Query" name:"WebGroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Action1     requests.Integer `position:"Query" name:"Action1"`
	Tag         string           `position:"Query" name:"Tag"`
	Flow        requests.Integer `position:"Query" name:"Flow"`
	Status      requests.Integer `position:"Query" name:"Status"`
}

// DescribeAllRegionsStatisticsResponse is the response struct for api DescribeAllRegionsStatistics
type DescribeAllRegionsStatisticsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeAllRegionsStatisticsRequest creates a request to invoke DescribeAllRegionsStatistics API
func CreateDescribeAllRegionsStatisticsRequest() (request *DescribeAllRegionsStatisticsRequest) {
	request = &DescribeAllRegionsStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeAllRegionsStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeAllRegionsStatisticsResponse creates a response to parse from DescribeAllRegionsStatistics response
func CreateDescribeAllRegionsStatisticsResponse() (response *DescribeAllRegionsStatisticsResponse) {
	response = &DescribeAllRegionsStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
