package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenSasTrial invokes the aegis.OpenSasTrial API synchronously
// api document: https://help.aliyun.com/api/aegis/opensastrial.html
func (client *Client) OpenSasTrial(request *OpenSasTrialRequest) (response *OpenSasTrialResponse, err error) {
	response = CreateOpenSasTrialResponse()
	err = client.DoAction(request, response)
	return
}

// OpenSasTrialWithChan invokes the aegis.OpenSasTrial API asynchronously
// api document: https://help.aliyun.com/api/aegis/opensastrial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenSasTrialWithChan(request *OpenSasTrialRequest) (<-chan *OpenSasTrialResponse, <-chan error) {
	responseChan := make(chan *OpenSasTrialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenSasTrial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenSasTrialWithCallback invokes the aegis.OpenSasTrial API asynchronously
// api document: https://help.aliyun.com/api/aegis/opensastrial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenSasTrialWithCallback(request *OpenSasTrialRequest, callback func(response *OpenSasTrialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenSasTrialResponse
		var err error
		defer close(result)
		response, err = client.OpenSasTrial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenSasTrialRequest is the request struct for api OpenSasTrial
type OpenSasTrialRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	BuyVersion string `position:"Query" name:"BuyVersion"`
}

// OpenSasTrialResponse is the response struct for api OpenSasTrial
type OpenSasTrialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenSasTrialRequest creates a request to invoke OpenSasTrial API
func CreateOpenSasTrialRequest() (request *OpenSasTrialRequest) {
	request = &OpenSasTrialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "OpenSasTrial", "vipaegis", "openAPI")
	return
}

// CreateOpenSasTrialResponse creates a response to parse from OpenSasTrial response
func CreateOpenSasTrialResponse() (response *OpenSasTrialResponse) {
	response = &OpenSasTrialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
