package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApgroupConfigProgress invokes the cloudwf.GetApgroupConfigProgress API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupconfigprogress.html
func (client *Client) GetApgroupConfigProgress(request *GetApgroupConfigProgressRequest) (response *GetApgroupConfigProgressResponse, err error) {
	response = CreateGetApgroupConfigProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetApgroupConfigProgressWithChan invokes the cloudwf.GetApgroupConfigProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupconfigprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApgroupConfigProgressWithChan(request *GetApgroupConfigProgressRequest) (<-chan *GetApgroupConfigProgressResponse, <-chan error) {
	responseChan := make(chan *GetApgroupConfigProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApgroupConfigProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApgroupConfigProgressWithCallback invokes the cloudwf.GetApgroupConfigProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapgroupconfigprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApgroupConfigProgressWithCallback(request *GetApgroupConfigProgressRequest, callback func(response *GetApgroupConfigProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApgroupConfigProgressResponse
		var err error
		defer close(result)
		response, err = client.GetApgroupConfigProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApgroupConfigProgressRequest is the request struct for api GetApgroupConfigProgress
type GetApgroupConfigProgressRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetApgroupConfigProgressResponse is the response struct for api GetApgroupConfigProgress
type GetApgroupConfigProgressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApgroupConfigProgressRequest creates a request to invoke GetApgroupConfigProgress API
func CreateGetApgroupConfigProgressRequest() (request *GetApgroupConfigProgressRequest) {
	request = &GetApgroupConfigProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApgroupConfigProgress", "cloudwf", "openAPI")
	return
}

// CreateGetApgroupConfigProgressResponse creates a response to parse from GetApgroupConfigProgress response
func CreateGetApgroupConfigProgressResponse() (response *GetApgroupConfigProgressResponse) {
	response = &GetApgroupConfigProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
