package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopGroupShowList invokes the cloudwf.ShopGroupShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupshowlist.html
func (client *Client) ShopGroupShowList(request *ShopGroupShowListRequest) (response *ShopGroupShowListResponse, err error) {
	response = CreateShopGroupShowListResponse()
	err = client.DoAction(request, response)
	return
}

// ShopGroupShowListWithChan invokes the cloudwf.ShopGroupShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGroupShowListWithChan(request *ShopGroupShowListRequest) (<-chan *ShopGroupShowListResponse, <-chan error) {
	responseChan := make(chan *ShopGroupShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopGroupShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopGroupShowListWithCallback invokes the cloudwf.ShopGroupShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgroupshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGroupShowListWithCallback(request *ShopGroupShowListRequest, callback func(response *ShopGroupShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopGroupShowListResponse
		var err error
		defer close(result)
		response, err = client.ShopGroupShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopGroupShowListRequest is the request struct for api ShopGroupShowList
type ShopGroupShowListRequest struct {
	*requests.RpcRequest
	Page requests.Integer `position:"Query" name:"Page"`
	Bid  requests.Integer `position:"Query" name:"Bid"`
	Per  requests.Integer `position:"Query" name:"Per"`
}

// ShopGroupShowListResponse is the response struct for api ShopGroupShowList
type ShopGroupShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopGroupShowListRequest creates a request to invoke ShopGroupShowList API
func CreateShopGroupShowListRequest() (request *ShopGroupShowListRequest) {
	request = &ShopGroupShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopGroupShowList", "cloudwf", "openAPI")
	return
}

// CreateShopGroupShowListResponse creates a response to parse from ShopGroupShowList response
func CreateShopGroupShowListResponse() (response *ShopGroupShowListResponse) {
	response = &ShopGroupShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
