package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDevopsOrganization invokes the devops_rdc.CreateDevopsOrganization API synchronously
func (client *Client) CreateDevopsOrganization(request *CreateDevopsOrganizationRequest) (response *CreateDevopsOrganizationResponse, err error) {
	response = CreateCreateDevopsOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDevopsOrganizationWithChan invokes the devops_rdc.CreateDevopsOrganization API asynchronously
func (client *Client) CreateDevopsOrganizationWithChan(request *CreateDevopsOrganizationRequest) (<-chan *CreateDevopsOrganizationResponse, <-chan error) {
	responseChan := make(chan *CreateDevopsOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDevopsOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDevopsOrganizationWithCallback invokes the devops_rdc.CreateDevopsOrganization API asynchronously
func (client *Client) CreateDevopsOrganizationWithCallback(request *CreateDevopsOrganizationRequest, callback func(response *CreateDevopsOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDevopsOrganizationResponse
		var err error
		defer close(result)
		response, err = client.CreateDevopsOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDevopsOrganizationRequest is the request struct for api CreateDevopsOrganization
type CreateDevopsOrganizationRequest struct {
	*requests.RpcRequest
	OrgName            string           `position:"Body" name:"OrgName"`
	Source             string           `position:"Body" name:"Source"`
	RealPk             string           `position:"Body" name:"RealPk"`
	DesiredMemberCount requests.Integer `position:"Body" name:"DesiredMemberCount"`
}

// CreateDevopsOrganizationResponse is the response struct for api CreateDevopsOrganization
type CreateDevopsOrganizationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       string `json:"Object" xml:"Object"`
}

// CreateCreateDevopsOrganizationRequest creates a request to invoke CreateDevopsOrganization API
func CreateCreateDevopsOrganizationRequest() (request *CreateDevopsOrganizationRequest) {
	request = &CreateDevopsOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CreateDevopsOrganization", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDevopsOrganizationResponse creates a response to parse from CreateDevopsOrganization response
func CreateCreateDevopsOrganizationResponse() (response *CreateDevopsOrganizationResponse) {
	response = &CreateDevopsOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
