package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCallTaskDetail invokes the dyvmsapi.ListCallTaskDetail API synchronously
func (client *Client) ListCallTaskDetail(request *ListCallTaskDetailRequest) (response *ListCallTaskDetailResponse, err error) {
	response = CreateListCallTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// ListCallTaskDetailWithChan invokes the dyvmsapi.ListCallTaskDetail API asynchronously
func (client *Client) ListCallTaskDetailWithChan(request *ListCallTaskDetailRequest) (<-chan *ListCallTaskDetailResponse, <-chan error) {
	responseChan := make(chan *ListCallTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCallTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCallTaskDetailWithCallback invokes the dyvmsapi.ListCallTaskDetail API asynchronously
func (client *Client) ListCallTaskDetailWithCallback(request *ListCallTaskDetailRequest, callback func(response *ListCallTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCallTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.ListCallTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCallTaskDetailRequest is the request struct for api ListCallTaskDetail
type ListCallTaskDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	CalledNum            string           `position:"Query" name:"CalledNum"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Status               string           `position:"Query" name:"Status"`
}

// ListCallTaskDetailResponse is the response struct for api ListCallTaskDetail
type ListCallTaskDetailResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	Total      int64      `json:"Total" xml:"Total"`
	TotalPage  int64      `json:"TotalPage" xml:"TotalPage"`
	PageSize   int64      `json:"PageSize" xml:"PageSize"`
	PageNumber int64      `json:"PageNumber" xml:"PageNumber"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateListCallTaskDetailRequest creates a request to invoke ListCallTaskDetail API
func CreateListCallTaskDetailRequest() (request *ListCallTaskDetailRequest) {
	request = &ListCallTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListCallTaskDetail", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCallTaskDetailResponse creates a response to parse from ListCallTaskDetail response
func CreateListCallTaskDetailResponse() (response *ListCallTaskDetailResponse) {
	response = &ListCallTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
