package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePublishFpgaImages invokes the faas.DescribePublishFpgaImages API synchronously
// api document: https://help.aliyun.com/api/faas/describepublishfpgaimages.html
func (client *Client) DescribePublishFpgaImages(request *DescribePublishFpgaImagesRequest) (response *DescribePublishFpgaImagesResponse, err error) {
	response = CreateDescribePublishFpgaImagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePublishFpgaImagesWithChan invokes the faas.DescribePublishFpgaImages API asynchronously
// api document: https://help.aliyun.com/api/faas/describepublishfpgaimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePublishFpgaImagesWithChan(request *DescribePublishFpgaImagesRequest) (<-chan *DescribePublishFpgaImagesResponse, <-chan error) {
	responseChan := make(chan *DescribePublishFpgaImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePublishFpgaImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePublishFpgaImagesWithCallback invokes the faas.DescribePublishFpgaImages API asynchronously
// api document: https://help.aliyun.com/api/faas/describepublishfpgaimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePublishFpgaImagesWithCallback(request *DescribePublishFpgaImagesRequest, callback func(response *DescribePublishFpgaImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePublishFpgaImagesResponse
		var err error
		defer close(result)
		response, err = client.DescribePublishFpgaImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePublishFpgaImagesRequest is the request struct for api DescribePublishFpgaImages
type DescribePublishFpgaImagesRequest struct {
	*requests.RpcRequest
	ImageID       string           `position:"Query" name:"ImageID"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CallerUid     requests.Integer `position:"Query" name:"callerUid"`
}

// DescribePublishFpgaImagesResponse is the response struct for api DescribePublishFpgaImages
type DescribePublishFpgaImagesResponse struct {
	*responses.BaseResponse
	RequestId  string                                `json:"RequestId" xml:"RequestId"`
	FpgaImages FpgaImagesInDescribePublishFpgaImages `json:"FpgaImages" xml:"FpgaImages"`
}

// CreateDescribePublishFpgaImagesRequest creates a request to invoke DescribePublishFpgaImages API
func CreateDescribePublishFpgaImagesRequest() (request *DescribePublishFpgaImagesRequest) {
	request = &DescribePublishFpgaImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2017-08-24", "DescribePublishFpgaImages", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePublishFpgaImagesResponse creates a response to parse from DescribePublishFpgaImages response
func CreateDescribePublishFpgaImagesResponse() (response *DescribePublishFpgaImagesResponse) {
	response = &DescribePublishFpgaImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
