package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentCloth invokes the imageseg.SegmentCloth API synchronously
func (client *Client) SegmentCloth(request *SegmentClothRequest) (response *SegmentClothResponse, err error) {
	response = CreateSegmentClothResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentClothWithChan invokes the imageseg.SegmentCloth API asynchronously
func (client *Client) SegmentClothWithChan(request *SegmentClothRequest) (<-chan *SegmentClothResponse, <-chan error) {
	responseChan := make(chan *SegmentClothResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentCloth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentClothWithCallback invokes the imageseg.SegmentCloth API asynchronously
func (client *Client) SegmentClothWithCallback(request *SegmentClothRequest, callback func(response *SegmentClothResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentClothResponse
		var err error
		defer close(result)
		response, err = client.SegmentCloth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentClothRequest is the request struct for api SegmentCloth
type SegmentClothRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Query" name:"ImageURL"`
}

// SegmentClothResponse is the response struct for api SegmentCloth
type SegmentClothResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentClothRequest creates a request to invoke SegmentCloth API
func CreateSegmentClothRequest() (request *SegmentClothRequest) {
	request = &SegmentClothRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentCloth", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentClothResponse creates a response to parse from SegmentCloth response
func CreateSegmentClothResponse() (response *SegmentClothResponse) {
	response = &SegmentClothResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
