package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProductTopic invokes the iot.DeleteProductTopic API synchronously
func (client *Client) DeleteProductTopic(request *DeleteProductTopicRequest) (response *DeleteProductTopicResponse, err error) {
	response = CreateDeleteProductTopicResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProductTopicWithChan invokes the iot.DeleteProductTopic API asynchronously
func (client *Client) DeleteProductTopicWithChan(request *DeleteProductTopicRequest) (<-chan *DeleteProductTopicResponse, <-chan error) {
	responseChan := make(chan *DeleteProductTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProductTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProductTopicWithCallback invokes the iot.DeleteProductTopic API asynchronously
func (client *Client) DeleteProductTopicWithCallback(request *DeleteProductTopicRequest, callback func(response *DeleteProductTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProductTopicResponse
		var err error
		defer close(result)
		response, err = client.DeleteProductTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProductTopicRequest is the request struct for api DeleteProductTopic
type DeleteProductTopicRequest struct {
	*requests.RpcRequest
	TopicId       string `position:"Query" name:"TopicId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteProductTopicResponse is the response struct for api DeleteProductTopic
type DeleteProductTopicResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteProductTopicRequest creates a request to invoke DeleteProductTopic API
func CreateDeleteProductTopicRequest() (request *DeleteProductTopicRequest) {
	request = &DeleteProductTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteProductTopic", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProductTopicResponse creates a response to parse from DeleteProductTopic response
func CreateDeleteProductTopicResponse() (response *DeleteProductTopicResponse) {
	response = &DeleteProductTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
