package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CertificatePrivateKeyDecrypt invokes the kms.CertificatePrivateKeyDecrypt API synchronously
func (client *Client) CertificatePrivateKeyDecrypt(request *CertificatePrivateKeyDecryptRequest) (response *CertificatePrivateKeyDecryptResponse, err error) {
	response = CreateCertificatePrivateKeyDecryptResponse()
	err = client.DoAction(request, response)
	return
}

// CertificatePrivateKeyDecryptWithChan invokes the kms.CertificatePrivateKeyDecrypt API asynchronously
func (client *Client) CertificatePrivateKeyDecryptWithChan(request *CertificatePrivateKeyDecryptRequest) (<-chan *CertificatePrivateKeyDecryptResponse, <-chan error) {
	responseChan := make(chan *CertificatePrivateKeyDecryptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CertificatePrivateKeyDecrypt(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CertificatePrivateKeyDecryptWithCallback invokes the kms.CertificatePrivateKeyDecrypt API asynchronously
func (client *Client) CertificatePrivateKeyDecryptWithCallback(request *CertificatePrivateKeyDecryptRequest, callback func(response *CertificatePrivateKeyDecryptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CertificatePrivateKeyDecryptResponse
		var err error
		defer close(result)
		response, err = client.CertificatePrivateKeyDecrypt(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CertificatePrivateKeyDecryptRequest is the request struct for api CertificatePrivateKeyDecrypt
type CertificatePrivateKeyDecryptRequest struct {
	*requests.RpcRequest
	CertificateId  string `position:"Query" name:"CertificateId"`
	Algorithm      string `position:"Query" name:"Algorithm"`
	CiphertextBlob string `position:"Query" name:"CiphertextBlob"`
}

// CertificatePrivateKeyDecryptResponse is the response struct for api CertificatePrivateKeyDecrypt
type CertificatePrivateKeyDecryptResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	CertificateId string `json:"CertificateId" xml:"CertificateId"`
	Plaintext     string `json:"Plaintext" xml:"Plaintext"`
}

// CreateCertificatePrivateKeyDecryptRequest creates a request to invoke CertificatePrivateKeyDecrypt API
func CreateCertificatePrivateKeyDecryptRequest() (request *CertificatePrivateKeyDecryptRequest) {
	request = &CertificatePrivateKeyDecryptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "CertificatePrivateKeyDecrypt", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCertificatePrivateKeyDecryptResponse creates a response to parse from CertificatePrivateKeyDecrypt response
func CreateCertificatePrivateKeyDecryptResponse() (response *CertificatePrivateKeyDecryptResponse) {
	response = &CertificatePrivateKeyDecryptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
