package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportFpShotJob invokes the mts.ImportFpShotJob API synchronously
func (client *Client) ImportFpShotJob(request *ImportFpShotJobRequest) (response *ImportFpShotJobResponse, err error) {
	response = CreateImportFpShotJobResponse()
	err = client.DoAction(request, response)
	return
}

// ImportFpShotJobWithChan invokes the mts.ImportFpShotJob API asynchronously
func (client *Client) ImportFpShotJobWithChan(request *ImportFpShotJobRequest) (<-chan *ImportFpShotJobResponse, <-chan error) {
	responseChan := make(chan *ImportFpShotJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportFpShotJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportFpShotJobWithCallback invokes the mts.ImportFpShotJob API asynchronously
func (client *Client) ImportFpShotJobWithCallback(request *ImportFpShotJobRequest, callback func(response *ImportFpShotJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportFpShotJobResponse
		var err error
		defer close(result)
		response, err = client.ImportFpShotJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportFpShotJobRequest is the request struct for api ImportFpShotJob
type ImportFpShotJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FpDBId               string           `position:"Query" name:"FpDBId"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	FpImportConfig       string           `position:"Query" name:"FpImportConfig"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Input                string           `position:"Query" name:"Input"`
}

// ImportFpShotJobResponse is the response struct for api ImportFpShotJob
type ImportFpShotJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateImportFpShotJobRequest creates a request to invoke ImportFpShotJob API
func CreateImportFpShotJobRequest() (request *ImportFpShotJobRequest) {
	request = &ImportFpShotJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ImportFpShotJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportFpShotJobResponse creates a response to parse from ImportFpShotJob response
func CreateImportFpShotJobResponse() (response *ImportFpShotJobResponse) {
	response = &ImportFpShotJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
