package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitImageSearchJob invokes the mts.SubmitImageSearchJob API synchronously
func (client *Client) SubmitImageSearchJob(request *SubmitImageSearchJobRequest) (response *SubmitImageSearchJobResponse, err error) {
	response = CreateSubmitImageSearchJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitImageSearchJobWithChan invokes the mts.SubmitImageSearchJob API asynchronously
func (client *Client) SubmitImageSearchJobWithChan(request *SubmitImageSearchJobRequest) (<-chan *SubmitImageSearchJobResponse, <-chan error) {
	responseChan := make(chan *SubmitImageSearchJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitImageSearchJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitImageSearchJobWithCallback invokes the mts.SubmitImageSearchJob API asynchronously
func (client *Client) SubmitImageSearchJobWithCallback(request *SubmitImageSearchJobRequest, callback func(response *SubmitImageSearchJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitImageSearchJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitImageSearchJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitImageSearchJobRequest is the request struct for api SubmitImageSearchJob
type SubmitImageSearchJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FpDBId               string           `position:"Query" name:"FpDBId"`
	UserData             string           `position:"Query" name:"UserData"`
	InputVideo           string           `position:"Query" name:"InputVideo"`
	InputImage           string           `position:"Query" name:"InputImage"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Config               string           `position:"Query" name:"Config"`
}

// SubmitImageSearchJobResponse is the response struct for api SubmitImageSearchJob
type SubmitImageSearchJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitImageSearchJobRequest creates a request to invoke SubmitImageSearchJob API
func CreateSubmitImageSearchJobRequest() (request *SubmitImageSearchJobRequest) {
	request = &SubmitImageSearchJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitImageSearchJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitImageSearchJobResponse creates a response to parse from SubmitImageSearchJob response
func CreateSubmitImageSearchJobResponse() (response *SubmitImageSearchJobResponse) {
	response = &SubmitImageSearchJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
