package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeAction invokes the nlp_automl.InvokeAction API synchronously
func (client *Client) InvokeAction(request *InvokeActionRequest) (response *InvokeActionResponse, err error) {
	response = CreateInvokeActionResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeActionWithChan invokes the nlp_automl.InvokeAction API asynchronously
func (client *Client) InvokeActionWithChan(request *InvokeActionRequest) (<-chan *InvokeActionResponse, <-chan error) {
	responseChan := make(chan *InvokeActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeActionWithCallback invokes the nlp_automl.InvokeAction API asynchronously
func (client *Client) InvokeActionWithCallback(request *InvokeActionRequest, callback func(response *InvokeActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeActionResponse
		var err error
		defer close(result)
		response, err = client.InvokeAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeActionRequest is the request struct for api InvokeAction
type InvokeActionRequest struct {
	*requests.RpcRequest
	InvokeProduct string `position:"Query" name:"InvokeProduct"`
	InvokeAction  string `position:"Body" name:"InvokeAction"`
	InvokeParams  string `position:"Body" name:"InvokeParams"`
	InvokeRegion  string `position:"Query" name:"InvokeRegion"`
}

// InvokeActionResponse is the response struct for api InvokeAction
type InvokeActionResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   int    `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInvokeActionRequest creates a request to invoke InvokeAction API
func CreateInvokeActionRequest() (request *InvokeActionRequest) {
	request = &InvokeActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "InvokeAction", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInvokeActionResponse creates a response to parse from InvokeAction response
func CreateInvokeActionResponse() (response *InvokeActionResponse) {
	response = &InvokeActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
