package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExecutionTemplate invokes the oos.GetExecutionTemplate API synchronously
func (client *Client) GetExecutionTemplate(request *GetExecutionTemplateRequest) (response *GetExecutionTemplateResponse, err error) {
	response = CreateGetExecutionTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetExecutionTemplateWithChan invokes the oos.GetExecutionTemplate API asynchronously
func (client *Client) GetExecutionTemplateWithChan(request *GetExecutionTemplateRequest) (<-chan *GetExecutionTemplateResponse, <-chan error) {
	responseChan := make(chan *GetExecutionTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExecutionTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExecutionTemplateWithCallback invokes the oos.GetExecutionTemplate API asynchronously
func (client *Client) GetExecutionTemplateWithCallback(request *GetExecutionTemplateRequest, callback func(response *GetExecutionTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExecutionTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetExecutionTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExecutionTemplateRequest is the request struct for api GetExecutionTemplate
type GetExecutionTemplateRequest struct {
	*requests.RpcRequest
	ExecutionId string `position:"Query" name:"ExecutionId"`
}

// GetExecutionTemplateResponse is the response struct for api GetExecutionTemplate
type GetExecutionTemplateResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Content   string   `json:"Content" xml:"Content"`
	Template  Template `json:"Template" xml:"Template"`
}

// CreateGetExecutionTemplateRequest creates a request to invoke GetExecutionTemplate API
func CreateGetExecutionTemplateRequest() (request *GetExecutionTemplateRequest) {
	request = &GetExecutionTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetExecutionTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateGetExecutionTemplateResponse creates a response to parse from GetExecutionTemplate response
func CreateGetExecutionTemplateResponse() (response *GetExecutionTemplateResponse) {
	response = &GetExecutionTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
