package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBLinks invokes the polardb.DescribeDBLinks API synchronously
func (client *Client) DescribeDBLinks(request *DescribeDBLinksRequest) (response *DescribeDBLinksResponse, err error) {
	response = CreateDescribeDBLinksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBLinksWithChan invokes the polardb.DescribeDBLinks API asynchronously
func (client *Client) DescribeDBLinksWithChan(request *DescribeDBLinksRequest) (<-chan *DescribeDBLinksResponse, <-chan error) {
	responseChan := make(chan *DescribeDBLinksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBLinks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBLinksWithCallback invokes the polardb.DescribeDBLinks API asynchronously
func (client *Client) DescribeDBLinksWithCallback(request *DescribeDBLinksRequest, callback func(response *DescribeDBLinksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBLinksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBLinks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBLinksRequest is the request struct for api DescribeDBLinks
type DescribeDBLinksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBLinkName           string           `position:"Query" name:"DBLinkName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBLinksResponse is the response struct for api DescribeDBLinks
type DescribeDBLinksResponse struct {
	*responses.BaseResponse
	RequestId      string            `json:"RequestId" xml:"RequestId"`
	DBInstanceName string            `json:"DBInstanceName" xml:"DBInstanceName"`
	DBLinkInfos    []DBLinkInfosItem `json:"DBLinkInfos" xml:"DBLinkInfos"`
}

// CreateDescribeDBLinksRequest creates a request to invoke DescribeDBLinks API
func CreateDescribeDBLinksRequest() (request *DescribeDBLinksRequest) {
	request = &DescribeDBLinksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBLinks", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDBLinksResponse creates a response to parse from DescribeDBLinks response
func CreateDescribeDBLinksResponse() (response *DescribeDBLinksResponse) {
	response = &DescribeDBLinksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
