package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDbList invokes the polardbx.DescribeDbList API synchronously
func (client *Client) DescribeDbList(request *DescribeDbListRequest) (response *DescribeDbListResponse, err error) {
	response = CreateDescribeDbListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDbListWithChan invokes the polardbx.DescribeDbList API asynchronously
func (client *Client) DescribeDbListWithChan(request *DescribeDbListRequest) (<-chan *DescribeDbListResponse, <-chan error) {
	responseChan := make(chan *DescribeDbListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDbList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDbListWithCallback invokes the polardbx.DescribeDbList API asynchronously
func (client *Client) DescribeDbListWithCallback(request *DescribeDbListRequest, callback func(response *DescribeDbListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDbListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDbList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDbListRequest is the request struct for api DescribeDbList
type DescribeDbListRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	DBName         string `position:"Query" name:"DBName"`
}

// DescribeDbListResponse is the response struct for api DescribeDbList
type DescribeDbListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      []DB   `json:"Data" xml:"Data"`
}

// CreateDescribeDbListRequest creates a request to invoke DescribeDbList API
func CreateDescribeDbListRequest() (request *DescribeDbListRequest) {
	request = &DescribeDbListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDbList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDbListResponse creates a response to parse from DescribeDbList response
func CreateDescribeDbListResponse() (response *DescribeDbListResponse) {
	response = &DescribeDbListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
