package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DesignateWorkers invokes the schedulerx2.DesignateWorkers API synchronously
func (client *Client) DesignateWorkers(request *DesignateWorkersRequest) (response *DesignateWorkersResponse, err error) {
	response = CreateDesignateWorkersResponse()
	err = client.DoAction(request, response)
	return
}

// DesignateWorkersWithChan invokes the schedulerx2.DesignateWorkers API asynchronously
func (client *Client) DesignateWorkersWithChan(request *DesignateWorkersRequest) (<-chan *DesignateWorkersResponse, <-chan error) {
	responseChan := make(chan *DesignateWorkersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DesignateWorkers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DesignateWorkersWithCallback invokes the schedulerx2.DesignateWorkers API asynchronously
func (client *Client) DesignateWorkersWithCallback(request *DesignateWorkersRequest, callback func(response *DesignateWorkersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DesignateWorkersResponse
		var err error
		defer close(result)
		response, err = client.DesignateWorkers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DesignateWorkersRequest is the request struct for api DesignateWorkers
type DesignateWorkersRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Query" name:"NamespaceSource"`
	GroupId         string           `position:"Query" name:"GroupId"`
	Transferable    requests.Boolean `position:"Query" name:"Transferable"`
	Labels          string           `position:"Query" name:"Labels"`
	DesignateType   requests.Integer `position:"Query" name:"DesignateType"`
	JobId           requests.Integer `position:"Query" name:"JobId"`
	Namespace       string           `position:"Query" name:"Namespace"`
	Workers         string           `position:"Query" name:"Workers"`
}

// DesignateWorkersResponse is the response struct for api DesignateWorkers
type DesignateWorkersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDesignateWorkersRequest creates a request to invoke DesignateWorkers API
func CreateDesignateWorkersRequest() (request *DesignateWorkersRequest) {
	request = &DesignateWorkersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "DesignateWorkers", "", "")
	request.Method = requests.GET
	return
}

// CreateDesignateWorkersResponse creates a response to parse from DesignateWorkers response
func CreateDesignateWorkersResponse() (response *DesignateWorkersResponse) {
	response = &DesignateWorkersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
