package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstances invokes the sddp.DescribeInstances API synchronously
func (client *Client) DescribeInstances(request *DescribeInstancesRequest) (response *DescribeInstancesResponse, err error) {
	response = CreateDescribeInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstancesWithChan invokes the sddp.DescribeInstances API asynchronously
func (client *Client) DescribeInstancesWithChan(request *DescribeInstancesRequest) (<-chan *DescribeInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstancesWithCallback invokes the sddp.DescribeInstances API asynchronously
func (client *Client) DescribeInstancesWithCallback(request *DescribeInstancesRequest, callback func(response *DescribeInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstancesRequest is the request struct for api DescribeInstances
type DescribeInstancesRequest struct {
	*requests.RpcRequest
	ProductCode         string           `position:"Query" name:"ProductCode"`
	ProductId           requests.Integer `position:"Query" name:"ProductId"`
	RiskLevels          string           `position:"Query" name:"RiskLevels"`
	QueryName           string           `position:"Query" name:"QueryName"`
	RiskLevelId         requests.Integer `position:"Query" name:"RiskLevelId"`
	Source              string           `position:"Query" name:"Source"`
	StartTime           requests.Integer `position:"Query" name:"StartTime"`
	UserId              requests.Integer `position:"Query" name:"UserId"`
	NameAccurate        string           `position:"Query" name:"NameAccurate"`
	SensLevelName       string           `position:"Query" name:"SensLevelName"`
	SourceIp            string           `position:"Query" name:"SourceIp"`
	LastFinishTimeStart requests.Integer `position:"Query" name:"LastFinishTimeStart"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
	CheckStatus         requests.Integer `position:"Query" name:"CheckStatus"`
	Lang                string           `position:"Query" name:"Lang"`
	QueryType           requests.Integer `position:"Query" name:"QueryType"`
	ServiceRegionId     string           `position:"Query" name:"ServiceRegionId"`
	EngineType          string           `position:"Query" name:"EngineType"`
	FeatureType         requests.Integer `position:"Query" name:"FeatureType"`
	OrderBy             string           `position:"Query" name:"OrderBy"`
	UserType            requests.Integer `position:"Query" name:"UserType"`
	EndTime             requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage         requests.Integer `position:"Query" name:"CurrentPage"`
	Name                string           `position:"Query" name:"Name"`
	RuleId              requests.Integer `position:"Query" name:"RuleId"`
	LastFinishTimeEnd   requests.Integer `position:"Query" name:"LastFinishTimeEnd"`
}

// DescribeInstancesResponse is the response struct for api DescribeInstances
type DescribeInstancesResponse struct {
	*responses.BaseResponse
	RequestId   string                        `json:"RequestId" xml:"RequestId"`
	PageSize    int                           `json:"PageSize" xml:"PageSize"`
	CurrentPage int                           `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int                           `json:"TotalCount" xml:"TotalCount"`
	Items       []InstanceInDescribeInstances `json:"Items" xml:"Items"`
}

// CreateDescribeInstancesRequest creates a request to invoke DescribeInstances API
func CreateDescribeInstancesRequest() (request *DescribeInstancesRequest) {
	request = &DescribeInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeInstances", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeInstancesResponse creates a response to parse from DescribeInstances response
func CreateDescribeInstancesResponse() (response *DescribeInstancesResponse) {
	response = &DescribeInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
