package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddVmAppToMesh invokes the servicemesh.AddVmAppToMesh API synchronously
func (client *Client) AddVmAppToMesh(request *AddVmAppToMeshRequest) (response *AddVmAppToMeshResponse, err error) {
	response = CreateAddVmAppToMeshResponse()
	err = client.DoAction(request, response)
	return
}

// AddVmAppToMeshWithChan invokes the servicemesh.AddVmAppToMesh API asynchronously
func (client *Client) AddVmAppToMeshWithChan(request *AddVmAppToMeshRequest) (<-chan *AddVmAppToMeshResponse, <-chan error) {
	responseChan := make(chan *AddVmAppToMeshResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddVmAppToMesh(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddVmAppToMeshWithCallback invokes the servicemesh.AddVmAppToMesh API asynchronously
func (client *Client) AddVmAppToMeshWithCallback(request *AddVmAppToMeshRequest, callback func(response *AddVmAppToMeshResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddVmAppToMeshResponse
		var err error
		defer close(result)
		response, err = client.AddVmAppToMesh(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddVmAppToMeshRequest is the request struct for api AddVmAppToMesh
type AddVmAppToMeshRequest struct {
	*requests.RpcRequest
	ServiceAccount string           `position:"Query" name:"ServiceAccount"`
	Annotations    string           `position:"Query" name:"Annotations"`
	Ports          string           `position:"Query" name:"Ports"`
	ServiceMeshId  string           `position:"Query" name:"ServiceMeshId"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	UseWorkload    requests.Boolean `position:"Query" name:"UseWorkload"`
	Ips            string           `position:"Query" name:"Ips"`
	Labels         string           `position:"Query" name:"Labels"`
	Namespace      string           `position:"Query" name:"Namespace"`
	Force          requests.Boolean `position:"Query" name:"Force"`
}

// AddVmAppToMeshResponse is the response struct for api AddVmAppToMesh
type AddVmAppToMeshResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateAddVmAppToMeshRequest creates a request to invoke AddVmAppToMesh API
func CreateAddVmAppToMeshRequest() (request *AddVmAppToMeshRequest) {
	request = &AddVmAppToMeshRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "AddVmAppToMesh", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddVmAppToMeshResponse creates a response to parse from AddVmAppToMesh response
func CreateAddVmAppToMeshResponse() (response *AddVmAppToMeshResponse) {
	response = &AddVmAppToMeshResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
