package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiagnosis invokes the servicemesh.GetDiagnosis API synchronously
func (client *Client) GetDiagnosis(request *GetDiagnosisRequest) (response *GetDiagnosisResponse, err error) {
	response = CreateGetDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiagnosisWithChan invokes the servicemesh.GetDiagnosis API asynchronously
func (client *Client) GetDiagnosisWithChan(request *GetDiagnosisRequest) (<-chan *GetDiagnosisResponse, <-chan error) {
	responseChan := make(chan *GetDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiagnosisWithCallback invokes the servicemesh.GetDiagnosis API asynchronously
func (client *Client) GetDiagnosisWithCallback(request *GetDiagnosisRequest, callback func(response *GetDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.GetDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiagnosisRequest is the request struct for api GetDiagnosis
type GetDiagnosisRequest struct {
	*requests.RpcRequest
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
}

// GetDiagnosisResponse is the response struct for api GetDiagnosis
type GetDiagnosisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	RunAt     string `json:"RunAt" xml:"RunAt"`
}

// CreateGetDiagnosisRequest creates a request to invoke GetDiagnosis API
func CreateGetDiagnosisRequest() (request *GetDiagnosisRequest) {
	request = &GetDiagnosisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "GetDiagnosis", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDiagnosisResponse creates a response to parse from GetDiagnosis response
func CreateGetDiagnosisResponse() (response *GetDiagnosisResponse) {
	response = &GetDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
