package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventCounts invokes the yundun_ds.DescribeEventCounts API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeeventcounts.html
func (client *Client) DescribeEventCounts(request *DescribeEventCountsRequest) (response *DescribeEventCountsResponse, err error) {
	response = CreateDescribeEventCountsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventCountsWithChan invokes the yundun_ds.DescribeEventCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeeventcounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventCountsWithChan(request *DescribeEventCountsRequest) (<-chan *DescribeEventCountsResponse, <-chan error) {
	responseChan := make(chan *DescribeEventCountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventCounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventCountsWithCallback invokes the yundun_ds.DescribeEventCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeeventcounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventCountsWithCallback(request *DescribeEventCountsRequest, callback func(response *DescribeEventCountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventCountsResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventCounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventCountsRequest is the request struct for api DescribeEventCounts
type DescribeEventCountsRequest struct {
	*requests.RpcRequest
	TypeCode    string           `position:"Query" name:"TypeCode"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	CountType   requests.Integer `position:"Query" name:"CountType"`
	Days        requests.Integer `position:"Query" name:"Days"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeEventCountsResponse is the response struct for api DescribeEventCounts
type DescribeEventCountsResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	EventCountList []EventCount `json:"EventCountList" xml:"EventCountList"`
}

// CreateDescribeEventCountsRequest creates a request to invoke DescribeEventCounts API
func CreateDescribeEventCountsRequest() (request *DescribeEventCountsRequest) {
	request = &DescribeEventCountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeEventCounts", "sddp", "openAPI")
	return
}

// CreateDescribeEventCountsResponse creates a response to parse from DescribeEventCounts response
func CreateDescribeEventCountsResponse() (response *DescribeEventCountsResponse) {
	response = &DescribeEventCountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
