/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#include <glib.h>

#include "rbcbuffer.h"


static inline RBCBuffer *
alloc_buffer (RBCBufferType type)
{
  RBCBuffer *buffer;

  buffer = g_new (RBCBuffer, 1);
  buffer->type = type;

  return buffer;
}


RBCBuffer *
rbc_buffer_empty_new (void)
{
  return alloc_buffer (RBC_BUFFER_EMPTY);
}

RBCBuffer *
rbc_buffer_simple_new (gsize length)
{
  RBCBuffer *buffer;

  g_return_val_if_fail (length > 0, NULL);

  buffer = alloc_buffer (RBC_BUFFER_SIMPLE);

  buffer->length = length;
  buffer->data = g_malloc (length);

  return buffer;
}

RBCBuffer *
rbc_buffer_page_table_new (gsize length)
{
  RBCBuffer *buffer;

  g_return_val_if_fail (length > 0, NULL);

  buffer = alloc_buffer (RBC_BUFFER_PAGE_TABLE);

  buffer->length = length;
  buffer->data = g_new (RBCPage, length);

  return buffer;
}

void
rbc_buffer_destroy (RBCBuffer *buffer)
{
  RBCPage *pages;
  gint     i;

  g_return_if_fail (buffer != NULL);

  switch (buffer->type)
    {

    case RBC_BUFFER_PAGE_TABLE:
      pages = buffer->data;

      for (i = 0; i < buffer->length; i++)
	g_free (pages[i].data);

      /* fall through */

    case RBC_BUFFER_SIMPLE:
      g_free (buffer->data);
      /* fall through */

    case RBC_BUFFER_EMPTY:
      g_free (buffer);
      break;

    default:
      g_assert_not_reached ();
      break;
    }
}

void
rbc_buffer_fill_from_page (RBCBuffer *buffer,
                           RBCPage   *page)
{
  g_return_if_fail (buffer != NULL);
  g_return_if_fail (page != NULL);

  buffer->type = RBC_BUFFER_SIMPLE;
  buffer->length = page->length;
  buffer->data = page->data;
}

