/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __RBC_DISK_H__
#define __RBC_DISK_H__


#include <glib.h>

#include <librbc/rbctypes.h>


RBCDisk     *rbc_disk_new            (RBCDiskType  type);

void         rbc_disk_destroy        (RBCDisk     *disk);

RBCDiskType  rbc_disk_get_type       (RBCDisk     *disk);

gboolean     rbc_disk_is_equal       (RBCDisk     *a,
				      RBCDisk     *b);

gboolean     rbc_disk_set_filename   (RBCDisk     *disk,
                                      const gchar *filename);

gboolean     rbc_disk_add_partition  (RBCDisk     *disk,
				      const gchar *filename,
				      guint        order);

gsize        rbc_disk_get_capacity   (RBCDisk     *disk);
gsize        rbc_disk_get_block_size (RBCDisk     *disk);

gboolean     rbc_disk_activate       (RBCDisk     *disk);


#endif /* __RBC_DISK_H__ */
