// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_online_store_admin_service.proto

#include "google/cloud/aiplatform/v1/feature_online_store_admin_connection.h"
#include "google/cloud/aiplatform/v1/feature_online_store_admin_options.h"
#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/feature_online_store_admin_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FeatureOnlineStoreAdminServiceConnection::
    ~FeatureOnlineStoreAdminServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureOnlineStore(
    google::cloud::aiplatform::v1::CreateFeatureOnlineStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureOnlineStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeatureOnlineStoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureOnlineStore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>
FeatureOnlineStoreAdminServiceConnection::GetFeatureOnlineStore(
    google::cloud::aiplatform::v1::GetFeatureOnlineStoreRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::FeatureOnlineStore>
FeatureOnlineStoreAdminServiceConnection::ListFeatureOnlineStores(
    google::cloud::aiplatform::v1::
        ListFeatureOnlineStoresRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureOnlineStore>>();
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureOnlineStore(
    google::cloud::aiplatform::v1::UpdateFeatureOnlineStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureOnlineStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeatureOnlineStoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureOnlineStore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureOnlineStore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureOnlineStore(
    google::cloud::aiplatform::v1::DeleteFeatureOnlineStoreRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureOnlineStore(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureOnlineStoreRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureOnlineStore(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureView(
    google::cloud::aiplatform::v1::CreateFeatureViewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureView(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeatureViewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnection::CreateFeatureView(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::FeatureView>
FeatureOnlineStoreAdminServiceConnection::GetFeatureView(
    google::cloud::aiplatform::v1::GetFeatureViewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::FeatureView>
FeatureOnlineStoreAdminServiceConnection::ListFeatureViews(
    google::cloud::aiplatform::v1::
        ListFeatureViewsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureView>>();
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureView(
    google::cloud::aiplatform::v1::UpdateFeatureViewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureView(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeatureViewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureView>>
FeatureOnlineStoreAdminServiceConnection::UpdateFeatureView(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureView>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureView(
    google::cloud::aiplatform::v1::DeleteFeatureViewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureView(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureViewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureOnlineStoreAdminServiceConnection::DeleteFeatureView(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::SyncFeatureViewResponse>
FeatureOnlineStoreAdminServiceConnection::SyncFeatureView(
    google::cloud::aiplatform::v1::SyncFeatureViewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::FeatureViewSync>
FeatureOnlineStoreAdminServiceConnection::GetFeatureViewSync(
    google::cloud::aiplatform::v1::GetFeatureViewSyncRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::FeatureViewSync>
FeatureOnlineStoreAdminServiceConnection::ListFeatureViewSyncs(
    google::cloud::aiplatform::v1::
        ListFeatureViewSyncsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureViewSync>>();
}

std::shared_ptr<FeatureOnlineStoreAdminServiceConnection>
MakeFeatureOnlineStoreAdminServiceConnection(std::string const& location,
                                             Options options) {
  internal::CheckExpectedOptions<
      CommonOptionList, GrpcOptionList, UnifiedCredentialsOptionList,
      FeatureOnlineStoreAdminServicePolicyOptionList>(options, __func__);
  options =
      aiplatform_v1_internal::FeatureOnlineStoreAdminServiceDefaultOptions(
          location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      aiplatform_v1_internal::CreateDefaultFeatureOnlineStoreAdminServiceStub(
          std::move(auth), options);
  return aiplatform_v1_internal::
      MakeFeatureOnlineStoreAdminServiceTracingConnection(
          std::make_shared<aiplatform_v1_internal::
                               FeatureOnlineStoreAdminServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
