// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/cloudquotas/v1/cloudquotas.proto

#include "google/cloud/cloudquotas/v1/cloud_quotas_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudquotas_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudQuotasClient::CloudQuotasClient(
    std::shared_ptr<CloudQuotasConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudQuotasClient::~CloudQuotasClient() = default;

StreamRange<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasClient::ListQuotaInfos(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::ListQuotaInfosRequest request;
  request.set_parent(parent);
  return connection_->ListQuotaInfos(request);
}

StreamRange<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasClient::ListQuotaInfos(
    google::api::cloudquotas::v1::ListQuotaInfosRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListQuotaInfos(std::move(request));
}

StatusOr<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasClient::GetQuotaInfo(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::GetQuotaInfoRequest request;
  request.set_name(name);
  return connection_->GetQuotaInfo(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaInfo>
CloudQuotasClient::GetQuotaInfo(
    google::api::cloudquotas::v1::GetQuotaInfoRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetQuotaInfo(request);
}

StreamRange<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::ListQuotaPreferences(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::ListQuotaPreferencesRequest request;
  request.set_parent(parent);
  return connection_->ListQuotaPreferences(request);
}

StreamRange<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::ListQuotaPreferences(
    google::api::cloudquotas::v1::ListQuotaPreferencesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListQuotaPreferences(std::move(request));
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::GetQuotaPreference(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::GetQuotaPreferenceRequest request;
  request.set_name(name);
  return connection_->GetQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::GetQuotaPreference(
    google::api::cloudquotas::v1::GetQuotaPreferenceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::CreateQuotaPreference(
    std::string const& parent,
    google::api::cloudquotas::v1::QuotaPreference const& quota_preference,
    std::string const& quota_preference_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::CreateQuotaPreferenceRequest request;
  request.set_parent(parent);
  *request.mutable_quota_preference() = quota_preference;
  request.set_quota_preference_id(quota_preference_id);
  return connection_->CreateQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::CreateQuotaPreference(
    std::string const& parent,
    google::api::cloudquotas::v1::QuotaPreference const& quota_preference,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::CreateQuotaPreferenceRequest request;
  request.set_parent(parent);
  *request.mutable_quota_preference() = quota_preference;
  return connection_->CreateQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::CreateQuotaPreference(
    google::api::cloudquotas::v1::CreateQuotaPreferenceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::UpdateQuotaPreference(
    google::api::cloudquotas::v1::QuotaPreference const& quota_preference,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest request;
  *request.mutable_quota_preference() = quota_preference;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateQuotaPreference(request);
}

StatusOr<google::api::cloudquotas::v1::QuotaPreference>
CloudQuotasClient::UpdateQuotaPreference(
    google::api::cloudquotas::v1::UpdateQuotaPreferenceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateQuotaPreference(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudquotas_v1
}  // namespace cloud
}  // namespace google
