// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_link_service.proto

#include "google/cloud/contentwarehouse/v1/document_link_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DocumentLinkServiceClient::DocumentLinkServiceClient(
    std::shared_ptr<DocumentLinkServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DocumentLinkServiceClient::~DocumentLinkServiceClient() = default;

StatusOr<google::cloud::contentwarehouse::v1::ListLinkedTargetsResponse>
DocumentLinkServiceClient::ListLinkedTargets(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::ListLinkedTargetsRequest request;
  request.set_parent(parent);
  return connection_->ListLinkedTargets(request);
}

StatusOr<google::cloud::contentwarehouse::v1::ListLinkedTargetsResponse>
DocumentLinkServiceClient::ListLinkedTargets(
    google::cloud::contentwarehouse::v1::ListLinkedTargetsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLinkedTargets(request);
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceClient::ListLinkedSources(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::ListLinkedSourcesRequest request;
  request.set_parent(parent);
  return connection_->ListLinkedSources(request);
}

StreamRange<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceClient::ListLinkedSources(
    google::cloud::contentwarehouse::v1::ListLinkedSourcesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLinkedSources(std::move(request));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceClient::CreateDocumentLink(
    std::string const& parent,
    google::cloud::contentwarehouse::v1::DocumentLink const& document_link,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::CreateDocumentLinkRequest request;
  request.set_parent(parent);
  *request.mutable_document_link() = document_link;
  return connection_->CreateDocumentLink(request);
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentLink>
DocumentLinkServiceClient::CreateDocumentLink(
    google::cloud::contentwarehouse::v1::CreateDocumentLinkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDocumentLink(request);
}

Status DocumentLinkServiceClient::DeleteDocumentLink(std::string const& name,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::DeleteDocumentLinkRequest request;
  request.set_name(name);
  return connection_->DeleteDocumentLink(request);
}

Status DocumentLinkServiceClient::DeleteDocumentLink(
    google::cloud::contentwarehouse::v1::DeleteDocumentLinkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDocumentLink(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
