// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/node_groups.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_NODE_GROUP_CONTROLLER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_NODE_GROUP_CONTROLLER_CLIENT_H

#include "google/cloud/dataproc/v1/node_group_controller_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// The `NodeGroupControllerService` provides methods to manage node groups
/// of Compute Engine managed instances.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NodeGroupControllerClient {
 public:
  explicit NodeGroupControllerClient(
      std::shared_ptr<NodeGroupControllerConnection> connection,
      Options opts = {});
  ~NodeGroupControllerClient();

  ///@{
  /// @name Copy and move support
  NodeGroupControllerClient(NodeGroupControllerClient const&) = default;
  NodeGroupControllerClient& operator=(NodeGroupControllerClient const&) =
      default;
  NodeGroupControllerClient(NodeGroupControllerClient&&) = default;
  NodeGroupControllerClient& operator=(NodeGroupControllerClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(NodeGroupControllerClient const& a,
                         NodeGroupControllerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NodeGroupControllerClient const& a,
                         NodeGroupControllerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a node group in a cluster. The returned
  /// [Operation.metadata][google.longrunning.Operation.metadata] is
  /// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
  ///
  /// @param parent  Required. The parent resource where this node group will be created.
  ///  Format: `projects/{project}/regions/{region}/clusters/{cluster}`
  /// @param node_group  Required. The node group to create.
  /// @param node_group_id  Optional. An optional node group ID. Generated if not specified.
  ///  @n
  ///  The ID must contain only letters (a-z, A-Z), numbers (0-9),
  ///  underscores (_), and hyphens (-). Cannot begin or end with underscore
  ///  or hyphen. Must consist of from 3 to 33 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dataproc.v1.NodeGroup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.CreateNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L86}
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  /// [google.longrunning.Operation.metadata]: @googleapis_reference_link{google/longrunning/operations.proto#L138}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> CreateNodeGroup(
      std::string const& parent,
      google::cloud::dataproc::v1::NodeGroup const& node_group,
      std::string const& node_group_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNodeGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNodeGroup(
      NoAwaitTag, std::string const& parent,
      google::cloud::dataproc::v1::NodeGroup const& node_group,
      std::string const& node_group_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a node group in a cluster. The returned
  /// [Operation.metadata][google.longrunning.Operation.metadata] is
  /// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataproc.v1.CreateNodeGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dataproc.v1.NodeGroup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.CreateNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L86}
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  /// [google.longrunning.Operation.metadata]: @googleapis_reference_link{google/longrunning/operations.proto#L138}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> CreateNodeGroup(
      google::cloud::dataproc::v1::CreateNodeGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNodeGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateNodeGroup(
      NoAwaitTag,
      google::cloud::dataproc::v1::CreateNodeGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateNodeGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> CreateNodeGroup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Resizes a node group in a cluster. The returned
  /// [Operation.metadata][google.longrunning.Operation.metadata] is
  /// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
  ///
  /// @param name  Required. The name of the node group to resize.
  ///  Format:
  ///  `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
  /// @param size  Required. The number of running instances for the node group to maintain.
  ///  The group adds or removes instances to maintain the number of instances
  ///  specified by this parameter.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dataproc.v1.NodeGroup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  /// [google.cloud.dataproc.v1.ResizeNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L122}
  /// [google.longrunning.Operation.metadata]: @googleapis_reference_link{google/longrunning/operations.proto#L138}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> ResizeNodeGroup(
      std::string const& name, std::int32_t size, Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeNodeGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResizeNodeGroup(
      NoAwaitTag, std::string const& name, std::int32_t size,
      Options opts = {});

  // clang-format off
  ///
  /// Resizes a node group in a cluster. The returned
  /// [Operation.metadata][google.longrunning.Operation.metadata] is
  /// [NodeGroupOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#nodegroupoperationmetadata).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataproc.v1.ResizeNodeGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dataproc.v1.NodeGroup] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  /// [google.cloud.dataproc.v1.ResizeNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L122}
  /// [google.longrunning.Operation.metadata]: @googleapis_reference_link{google/longrunning/operations.proto#L138}
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> ResizeNodeGroup(
      google::cloud::dataproc::v1::ResizeNodeGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeNodeGroup
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ResizeNodeGroup(
      NoAwaitTag,
      google::cloud::dataproc::v1::ResizeNodeGroupRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ResizeNodeGroup
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::dataproc::v1::NodeGroup>> ResizeNodeGroup(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets the resource representation for a node group in a
  /// cluster.
  ///
  /// @param name  Required. The name of the node group to retrieve.
  ///  Format:
  ///  `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataproc.v1.NodeGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.GetNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L164}
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  ///
  // clang-format on
  StatusOr<google::cloud::dataproc::v1::NodeGroup> GetNodeGroup(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the resource representation for a node group in a
  /// cluster.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataproc.v1.GetNodeGroupRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataproc.v1.NodeGroup])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataproc.v1.GetNodeGroupRequest]: @googleapis_reference_link{google/cloud/dataproc/v1/node_groups.proto#L164}
  /// [google.cloud.dataproc.v1.NodeGroup]: @googleapis_reference_link{google/cloud/dataproc/v1/clusters.proto#L905}
  ///
  // clang-format on
  StatusOr<google::cloud::dataproc::v1::NodeGroup> GetNodeGroup(
      google::cloud::dataproc::v1::GetNodeGroupRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<NodeGroupControllerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPROC_V1_NODE_GROUP_CONTROLLER_CLIENT_H
