// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/generator.proto

#include "google/cloud/dialogflow_es/internal/generators_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GeneratorsTracingConnection::GeneratorsTracingConnection(
    std::shared_ptr<dialogflow_es::GeneratorsConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::dialogflow::v2::Generator>
GeneratorsTracingConnection::CreateGenerator(
    google::cloud::dialogflow::v2::CreateGeneratorRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::GeneratorsConnection::CreateGenerator");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateGenerator(request));
}

StatusOr<google::cloud::dialogflow::v2::Generator>
GeneratorsTracingConnection::GetGenerator(
    google::cloud::dialogflow::v2::GetGeneratorRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_es::GeneratorsConnection::GetGenerator");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGenerator(request));
}

StreamRange<google::cloud::dialogflow::v2::Generator>
GeneratorsTracingConnection::ListGenerators(
    google::cloud::dialogflow::v2::ListGeneratorsRequest request) {
  auto span =
      internal::MakeSpan("dialogflow_es::GeneratorsConnection::ListGenerators");
  internal::OTelScope scope(span);
  auto sr = child_->ListGenerators(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::v2::Generator>(std::move(span), std::move(sr));
}

Status GeneratorsTracingConnection::DeleteGenerator(
    google::cloud::dialogflow::v2::DeleteGeneratorRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::GeneratorsConnection::DeleteGenerator");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteGenerator(request));
}

StatusOr<google::cloud::dialogflow::v2::Generator>
GeneratorsTracingConnection::UpdateGenerator(
    google::cloud::dialogflow::v2::UpdateGeneratorRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::GeneratorsConnection::UpdateGenerator");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateGenerator(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_es::GeneratorsConnection>
MakeGeneratorsTracingConnection(
    std::shared_ptr<dialogflow_es::GeneratorsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GeneratorsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
