// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/alert_service.proto

#include "google/cloud/monitoring/v3/alert_policy_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

AlertPolicyServiceConnectionIdempotencyPolicy::
    ~AlertPolicyServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<AlertPolicyServiceConnectionIdempotencyPolicy>
AlertPolicyServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<AlertPolicyServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency AlertPolicyServiceConnectionIdempotencyPolicy::ListAlertPolicies(
    google::monitoring::v3::ListAlertPoliciesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency AlertPolicyServiceConnectionIdempotencyPolicy::GetAlertPolicy(
    google::monitoring::v3::GetAlertPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency AlertPolicyServiceConnectionIdempotencyPolicy::CreateAlertPolicy(
    google::monitoring::v3::CreateAlertPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AlertPolicyServiceConnectionIdempotencyPolicy::DeleteAlertPolicy(
    google::monitoring::v3::DeleteAlertPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency AlertPolicyServiceConnectionIdempotencyPolicy::UpdateAlertPolicy(
    google::monitoring::v3::UpdateAlertPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<AlertPolicyServiceConnectionIdempotencyPolicy>
MakeDefaultAlertPolicyServiceConnectionIdempotencyPolicy() {
  return std::make_unique<AlertPolicyServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3
}  // namespace cloud
}  // namespace google
