// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_REACHABILITY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_REACHABILITY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/networkmanagement/v1/reachability.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkmanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ReachabilityServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ReachabilityServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency ListConnectivityTests(
      google::cloud::networkmanagement::v1::ListConnectivityTestsRequest
          request);

  virtual google::cloud::Idempotency GetConnectivityTest(
      google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
          request);

  virtual google::cloud::Idempotency CreateConnectivityTest(
      google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
          request);

  virtual google::cloud::Idempotency UpdateConnectivityTest(
      google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
          request);

  virtual google::cloud::Idempotency RerunConnectivityTest(
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
          request);

  virtual google::cloud::Idempotency DeleteConnectivityTest(
      google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
          request);
};

std::unique_ptr<ReachabilityServiceConnectionIdempotencyPolicy>
MakeDefaultReachabilityServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKMANAGEMENT_V1_REACHABILITY_CONNECTION_IDEMPOTENCY_POLICY_H
