// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v1/cloud_speech_adaptation.proto

#include "google/cloud/speech/v1/internal/adaptation_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/speech/v1/cloud_speech_adaptation.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace speech_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdaptationLogging::AdaptationLogging(std::shared_ptr<AdaptationStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationLogging::CreatePhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::CreatePhraseSetRequest const& request) {
        return child_->CreatePhraseSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::PhraseSet> AdaptationLogging::GetPhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::GetPhraseSetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::GetPhraseSetRequest const& request) {
        return child_->GetPhraseSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::ListPhraseSetResponse>
AdaptationLogging::ListPhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::ListPhraseSetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::ListPhraseSetRequest const& request) {
        return child_->ListPhraseSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::PhraseSet>
AdaptationLogging::UpdatePhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::UpdatePhraseSetRequest const& request) {
        return child_->UpdatePhraseSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status AdaptationLogging::DeletePhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::DeletePhraseSetRequest const& request) {
        return child_->DeletePhraseSet(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationLogging::CreateCustomClass(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::CreateCustomClassRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::speech::v1::CreateCustomClassRequest const& request) {
        return child_->CreateCustomClass(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationLogging::GetCustomClass(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::GetCustomClassRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::speech::v1::GetCustomClassRequest const& request) {
        return child_->GetCustomClass(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::ListCustomClassesResponse>
AdaptationLogging::ListCustomClasses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::ListCustomClassesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::speech::v1::ListCustomClassesRequest const& request) {
        return child_->ListCustomClasses(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::speech::v1::CustomClass>
AdaptationLogging::UpdateCustomClass(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::speech::v1::UpdateCustomClassRequest const& request) {
        return child_->UpdateCustomClass(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status AdaptationLogging::DeleteCustomClass(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::speech::v1::DeleteCustomClassRequest const& request) {
        return child_->DeleteCustomClass(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v1_internal
}  // namespace cloud
}  // namespace google
