// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/translation_connection.h"
#include "google/cloud/translate/v3/internal/translation_connection_impl.h"
#include "google/cloud/translate/v3/internal/translation_option_defaults.h"
#include "google/cloud/translate/v3/internal/translation_stub_factory.h"
#include "google/cloud/translate/v3/internal/translation_tracing_connection.h"
#include "google/cloud/translate/v3/translation_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace translate_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranslationServiceConnection::~TranslationServiceConnection() = default;

StatusOr<google::cloud::translation::v3::TranslateTextResponse>
TranslationServiceConnection::TranslateText(
    google::cloud::translation::v3::TranslateTextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::RomanizeTextResponse>
TranslationServiceConnection::RomanizeText(
    google::cloud::translation::v3::RomanizeTextRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::DetectLanguageResponse>
TranslationServiceConnection::DetectLanguage(
    google::cloud::translation::v3::DetectLanguageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::SupportedLanguages>
TranslationServiceConnection::GetSupportedLanguages(
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::TranslateDocumentResponse>
TranslationServiceConnection::TranslateDocument(
    google::cloud::translation::v3::TranslateDocumentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceConnection::BatchTranslateText(
    google::cloud::translation::v3::BatchTranslateTextRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::BatchTranslateText(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateTextRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>
TranslationServiceConnection::BatchTranslateText(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::BatchTranslateResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceConnection::BatchTranslateDocument(
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::BatchTranslateDocument(
    NoAwaitTag,
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>
TranslationServiceConnection::BatchTranslateDocument(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::BatchTranslateDocumentResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnection::CreateGlossary(
    google::cloud::translation::v3::CreateGlossaryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Glossary>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::CreateGlossary(
    NoAwaitTag, google::cloud::translation::v3::CreateGlossaryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnection::CreateGlossary(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Glossary>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnection::UpdateGlossary(
    google::cloud::translation::v3::UpdateGlossaryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Glossary>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::UpdateGlossary(
    NoAwaitTag, google::cloud::translation::v3::UpdateGlossaryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Glossary>>
TranslationServiceConnection::UpdateGlossary(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Glossary>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::translation::v3::Glossary>
TranslationServiceConnection::ListGlossaries(
    google::cloud::translation::v3::
        ListGlossariesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::Glossary>>();
}

StatusOr<google::cloud::translation::v3::Glossary>
TranslationServiceConnection::GetGlossary(
    google::cloud::translation::v3::GetGlossaryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceConnection::DeleteGlossary(
    google::cloud::translation::v3::DeleteGlossaryRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::DeleteGlossary(
    NoAwaitTag, google::cloud::translation::v3::DeleteGlossaryRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>
TranslationServiceConnection::DeleteGlossary(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteGlossaryResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnection::GetGlossaryEntry(
    google::cloud::translation::v3::GetGlossaryEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnection::ListGlossaryEntries(
    google::cloud::translation::v3::
        ListGlossaryEntriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::GlossaryEntry>>();
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnection::CreateGlossaryEntry(
    google::cloud::translation::v3::CreateGlossaryEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::GlossaryEntry>
TranslationServiceConnection::UpdateGlossaryEntry(
    google::cloud::translation::v3::UpdateGlossaryEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TranslationServiceConnection::DeleteGlossaryEntry(
    google::cloud::translation::v3::DeleteGlossaryEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceConnection::CreateDataset(
    google::cloud::translation::v3::CreateDatasetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Dataset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::CreateDataset(
    NoAwaitTag, google::cloud::translation::v3::CreateDatasetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Dataset>>
TranslationServiceConnection::CreateDataset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Dataset>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::translation::v3::Dataset>
TranslationServiceConnection::GetDataset(
    google::cloud::translation::v3::GetDatasetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::translation::v3::Dataset>
TranslationServiceConnection::ListDatasets(
    google::cloud::translation::v3::
        ListDatasetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::Dataset>>();
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceConnection::DeleteDataset(
    google::cloud::translation::v3::DeleteDatasetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::DeleteDataset(
    NoAwaitTag, google::cloud::translation::v3::DeleteDatasetRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>
TranslationServiceConnection::DeleteDataset(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteDatasetMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnection::CreateAdaptiveMtDataset(
    google::cloud::translation::v3::CreateAdaptiveMtDatasetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TranslationServiceConnection::DeleteAdaptiveMtDataset(
    google::cloud::translation::v3::DeleteAdaptiveMtDatasetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnection::GetAdaptiveMtDataset(
    google::cloud::translation::v3::GetAdaptiveMtDatasetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>
TranslationServiceConnection::ListAdaptiveMtDatasets(
    google::cloud::translation::v3::
        ListAdaptiveMtDatasetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtDataset>>();
}

StatusOr<google::cloud::translation::v3::AdaptiveMtTranslateResponse>
TranslationServiceConnection::AdaptiveMtTranslate(
    google::cloud::translation::v3::AdaptiveMtTranslateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceConnection::GetAdaptiveMtFile(
    google::cloud::translation::v3::GetAdaptiveMtFileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status TranslationServiceConnection::DeleteAdaptiveMtFile(
    google::cloud::translation::v3::DeleteAdaptiveMtFileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::translation::v3::ImportAdaptiveMtFileResponse>
TranslationServiceConnection::ImportAdaptiveMtFile(
    google::cloud::translation::v3::ImportAdaptiveMtFileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::translation::v3::AdaptiveMtFile>
TranslationServiceConnection::ListAdaptiveMtFiles(
    google::cloud::translation::v3::
        ListAdaptiveMtFilesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtFile>>();
}

StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>
TranslationServiceConnection::ListAdaptiveMtSentences(
    google::cloud::translation::v3::
        ListAdaptiveMtSentencesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::AdaptiveMtSentence>>();
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceConnection::ImportData(
    google::cloud::translation::v3::ImportDataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::ImportDataMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::ImportData(
    NoAwaitTag, google::cloud::translation::v3::ImportDataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::ImportDataMetadata>>
TranslationServiceConnection::ImportData(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::ImportDataMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceConnection::ExportData(
    google::cloud::translation::v3::ExportDataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::ExportDataMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::ExportData(
    NoAwaitTag, google::cloud::translation::v3::ExportDataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::ExportDataMetadata>>
TranslationServiceConnection::ExportData(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::ExportDataMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::translation::v3::Example>
TranslationServiceConnection::ListExamples(
    google::cloud::translation::v3::
        ListExamplesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::Example>>();
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceConnection::CreateModel(
    google::cloud::translation::v3::CreateModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Model>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::CreateModel(
    NoAwaitTag, google::cloud::translation::v3::CreateModelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::Model>>
TranslationServiceConnection::CreateModel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::Model>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::translation::v3::Model>
TranslationServiceConnection::ListModels(
    google::cloud::translation::v3::
        ListModelsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::translation::v3::Model>>();
}

StatusOr<google::cloud::translation::v3::Model>
TranslationServiceConnection::GetModel(
    google::cloud::translation::v3::GetModelRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceConnection::DeleteModel(
    google::cloud::translation::v3::DeleteModelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
TranslationServiceConnection::DeleteModel(
    NoAwaitTag, google::cloud::translation::v3::DeleteModelRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>
TranslationServiceConnection::DeleteModel(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::translation::v3::DeleteModelMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<TranslationServiceConnection> MakeTranslationServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TranslationServicePolicyOptionList>(options,
                                                                     __func__);
  options = translate_v3_internal::TranslationServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = translate_v3_internal::CreateDefaultTranslationServiceStub(
      std::move(auth), options);
  return translate_v3_internal::MakeTranslationServiceTracingConnection(
      std::make_shared<translate_v3_internal::TranslationServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3
}  // namespace cloud
}  // namespace google
