/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;
import org.jmock.core.Verifiable;
import org.jmock.core.stub.TestFailureStub;

public abstract class AbstractInvocationDispatcher
implements InvocationDispatcher {
    public static final String NO_EXPECTATIONS_MESSAGE = "No expectations set";
    protected List invokables = new ArrayList();
    protected Stub defaultStub = new TestFailureStub("unexpected invocation");

    public void setDefaultStub(Stub defaultStub) {
        this.defaultStub = defaultStub;
    }

    public void add(Invokable invokable) {
        this.invokables.add(invokable);
    }

    public void verify() {
        Iterator i = this.invokables.iterator();
        while (i.hasNext()) {
            ((Verifiable)i.next()).verify();
        }
    }

    public void clear() {
        this.invokables.clear();
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        if (this.anyInvokableHasDescription()) {
            this.writeInvokablesTo(buffer);
        } else {
            buffer.append(NO_EXPECTATIONS_MESSAGE);
        }
        return buffer;
    }

    private void writeInvokablesTo(StringBuffer buffer) {
        for (Invokable invokable : this.invokables) {
            if (!invokable.hasDescription()) continue;
            invokable.describeTo(buffer).append("\n");
        }
    }

    private boolean anyInvokableHasDescription() {
        Iterator iterator = this.invokables.iterator();
        while (iterator.hasNext()) {
            if (!((Invokable)iterator.next()).hasDescription()) continue;
            return true;
        }
        return false;
    }

    public Object dispatch(Invocation invocation) throws Throwable {
        Iterator i = this.dispatchOrder(this.invokables);
        while (i.hasNext()) {
            Invokable invokable = (Invokable)i.next();
            if (!invokable.matches(invocation)) continue;
            return invokable.invoke(invocation);
        }
        return this.defaultStub.invoke(invocation);
    }

    protected abstract Iterator dispatchOrder(List var1);
}

