package vulnerability

type FixState string

const (
	FixStateUnknown  FixState = "unknown"
	FixStateFixed    FixState = "fixed"
	FixStateNotFixed FixState = "not-fixed"
	FixStateWontFix  FixState = "wont-fix"
)

func AllFixStates() []FixState {
	return []FixState{
		FixStateFixed,
		FixStateNotFixed,
		FixStateUnknown,
		FixStateWontFix,
	}
}

type Fix struct {
	Versions []string
	State    FixState
}

func (f FixState) String() string {
	return string(f)
}
