/*
 * This file is part of the Colobot: Gold Edition source code
 * Copyright (C) 2001-2023, Daniel Roux, EPSITEC SA & TerranovaTeam
 * http://epsitec.ch; http://colobot.info; http://github.com/colobot
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://gnu.org/licenses
 */

#include "object/object_type.h"

#include <unordered_set>

bool IsValidObjectTypeId(int id)
{
    static const std::unordered_set<int> validIds{
        OBJECT_NULL,
        OBJECT_PORTICO,
        OBJECT_BASE,
        OBJECT_DERRICK,
        OBJECT_FACTORY,
        OBJECT_STATION,
        OBJECT_CONVERT,
        OBJECT_REPAIR,
        OBJECT_TOWER,
        OBJECT_NEST,
        OBJECT_RESEARCH,
        OBJECT_RADAR,
        OBJECT_ENERGY,
        OBJECT_LABO,
        OBJECT_NUCLEAR,
        OBJECT_START,
        OBJECT_END,
        OBJECT_INFO,
        OBJECT_PARA,
        OBJECT_TARGET1,
        OBJECT_TARGET2,
        OBJECT_SAFE,
        OBJECT_HUSTON,
        OBJECT_DESTROYER,
        OBJECT_STONE,
        OBJECT_URANIUM,
        OBJECT_METAL,
        OBJECT_POWER,
        OBJECT_ATOMIC,
        OBJECT_BULLET,
        OBJECT_BBOX,
        OBJECT_TNT,
        OBJECT_MARKPOWER,
        OBJECT_MARKSTONE,
        OBJECT_MARKURANIUM,
        OBJECT_MARKKEYa,
        OBJECT_MARKKEYb,
        OBJECT_MARKKEYc,
        OBJECT_MARKKEYd,
        OBJECT_BOMB,
        OBJECT_WINFIRE,
        OBJECT_SHOW,
        OBJECT_BAG,
        OBJECT_PLANT0,
        OBJECT_PLANT1,
        OBJECT_PLANT2,
        OBJECT_PLANT3,
        OBJECT_PLANT4,
        OBJECT_PLANT5,
        OBJECT_PLANT6,
        OBJECT_PLANT7,
        OBJECT_PLANT8,
        OBJECT_PLANT9,
        OBJECT_PLANT10,
        OBJECT_PLANT11,
        OBJECT_PLANT12,
        OBJECT_PLANT13,
        OBJECT_PLANT14,
        OBJECT_PLANT15,
        OBJECT_PLANT16,
        OBJECT_PLANT17,
        OBJECT_PLANT18,
        OBJECT_PLANT19,
        OBJECT_TREE0,
        OBJECT_TREE1,
        OBJECT_TREE2,
        OBJECT_TREE3,
        OBJECT_TREE4,
        OBJECT_TREE5,
        OBJECT_MOBILEwt,
        OBJECT_MOBILEtt,
        OBJECT_MOBILEft,
        OBJECT_MOBILEit,
        OBJECT_MOBILErp,
        OBJECT_MOBILEst,
        OBJECT_MOBILEwa,
        OBJECT_MOBILEta,
        OBJECT_MOBILEfa,
        OBJECT_MOBILEia,
        OBJECT_MOBILEwc,
        OBJECT_MOBILEtc,
        OBJECT_MOBILEfc,
        OBJECT_MOBILEic,
        OBJECT_MOBILEwi,
        OBJECT_MOBILEti,
        OBJECT_MOBILEfi,
        OBJECT_MOBILEii,
        OBJECT_MOBILEws,
        OBJECT_MOBILEts,
        OBJECT_MOBILEfs,
        OBJECT_MOBILEis,
        OBJECT_MOBILErt,
        OBJECT_MOBILErc,
        OBJECT_MOBILErr,
        OBJECT_MOBILErs,
        OBJECT_MOBILEsa,
        OBJECT_MOBILEtg,
        OBJECT_MOBILEdr,
        OBJECT_CONTROLLER,
        OBJECT_MOBILEwb,
        OBJECT_MOBILEtb,
        OBJECT_MOBILEfb,
        OBJECT_MOBILEib,
        OBJECT_MOBILEpr,
        OBJECT_WAYPOINT,
        OBJECT_FLAGb,
        OBJECT_FLAGr,
        OBJECT_FLAGg,
        OBJECT_FLAGy,
        OBJECT_FLAGv,
        OBJECT_KEYa,
        OBJECT_KEYb,
        OBJECT_KEYc,
        OBJECT_KEYd,
        OBJECT_HUMAN,
        OBJECT_TOTO,
        OBJECT_TECH,
        OBJECT_BARRIER0,
        OBJECT_BARRIER1,
        OBJECT_BARRIER2,
        OBJECT_BARRIER3,
        OBJECT_BARRICADE0,
        OBJECT_BARRICADE1,
        OBJECT_MOTHER,
        OBJECT_EGG,
        OBJECT_ANT,
        OBJECT_SPIDER,
        OBJECT_BEE,
        OBJECT_WORM,
        OBJECT_RUINmobilew1,
        OBJECT_RUINmobilew2,
        OBJECT_RUINmobilet1,
        OBJECT_RUINmobilet2,
        OBJECT_RUINmobiler1,
        OBJECT_RUINmobiler2,
        OBJECT_RUINfactory,
        OBJECT_RUINdoor,
        OBJECT_RUINsupport,
        OBJECT_RUINradar,
        OBJECT_RUINconvert,
        OBJECT_RUINbase,
        OBJECT_RUINhead,
        OBJECT_TEEN0,
        OBJECT_TEEN1,
        OBJECT_TEEN2,
        OBJECT_TEEN3,
        OBJECT_TEEN4,
        OBJECT_TEEN5,
        OBJECT_TEEN6,
        OBJECT_TEEN7,
        OBJECT_TEEN8,
        OBJECT_TEEN9,
        OBJECT_TEEN10,
        OBJECT_TEEN11,
        OBJECT_TEEN12,
        OBJECT_TEEN13,
        OBJECT_TEEN14,
        OBJECT_TEEN15,
        OBJECT_TEEN16,
        OBJECT_TEEN17,
        OBJECT_TEEN18,
        OBJECT_TEEN19,
        OBJECT_TEEN20,
        OBJECT_TEEN21,
        OBJECT_TEEN22,
        OBJECT_TEEN23,
        OBJECT_TEEN24,
        OBJECT_TEEN25,
        OBJECT_TEEN26,
        OBJECT_TEEN27,
        OBJECT_TEEN28,
        OBJECT_TEEN29,
        OBJECT_TEEN30,
        OBJECT_TEEN31,
        OBJECT_TEEN32,
        OBJECT_TEEN33,
        OBJECT_TEEN34,
        OBJECT_TEEN35,
        OBJECT_TEEN36,
        OBJECT_TEEN37,
        OBJECT_TEEN38,
        OBJECT_TEEN39,
        OBJECT_TEEN40,
        OBJECT_TEEN41,
        OBJECT_TEEN42,
        OBJECT_TEEN43,
        OBJECT_TEEN44,
        OBJECT_QUARTZ0,
        OBJECT_QUARTZ1,
        OBJECT_QUARTZ2,
        OBJECT_QUARTZ3,
        OBJECT_ROOT0,
        OBJECT_ROOT1,
        OBJECT_ROOT2,
        OBJECT_ROOT3,
        OBJECT_ROOT4,
        OBJECT_ROOT5,
        OBJECT_MUSHROOM1,
        OBJECT_MUSHROOM2,
        OBJECT_APOLLO1,
        OBJECT_APOLLO2,
        OBJECT_APOLLO3,
        OBJECT_APOLLO4,
        OBJECT_APOLLO5,
        OBJECT_HOME1,

        OBJECT_MAX
    };
    return validIds.count(id);
}
