/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.events;

import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;

public class InstallerDownloadEvent
extends InstallerEvent {
    private URL url;
    private File downloadFile;
    private long downloadSize;
    private Set downloadProgressListeners = new LinkedHashSet();

    public InstallerDownloadEvent(Object object, Context context, EventType eventType, boolean bl, URL uRL, File file, long l) {
        super(object, context, eventType, bl);
        this.init(uRL, file, l);
    }

    public InstallerDownloadEvent(Object object, Context context, EventType eventType, URL uRL, File file, long l) {
        super(object, context, eventType);
        this.init(uRL, file, l);
    }

    private void init(URL uRL, File file, long l) {
        this.url = uRL;
        this.downloadFile = file;
        this.downloadSize = l;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDownloadFile() {
        return this.downloadFile;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public void addDownloadProgressListener(DownloadProgressListener downloadProgressListener) {
        this.downloadProgressListeners.add(downloadProgressListener);
    }

    public Set getDownloadProgressListeners() {
        return this.downloadProgressListeners;
    }

    public String toString() {
        return super.toString() + " [url " + this.url + ", file " + this.downloadFile + ", size " + this.downloadSize + "]";
    }

    public String getVerbose() {
        String string = super.getVerbose() + ": " + this.url + " to " + this.downloadFile;
        if (this.getType() == EventType.BEFORE_DOWNLOAD) {
            string = string + "; size: " + this.downloadSize + " bytes";
        }
        return string;
    }

    public static interface DownloadProgressListener {
        public void downloadCompleted(long var1);
    }
}

