/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.AbstractInstallFilesAction;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.IOException;
import java.util.Iterator;

public class DownloadAndInstallComponentAction
extends AbstractInstallFilesAction {
    private String componentId = "";
    private boolean showProgress = true;

    public String getComponentId() {
        return DownloadAndInstallComponentAction.replaceVariables(this.componentId);
    }

    public void setComponentId(String string) {
        this.componentId = string;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    protected ProgressInterface getProgressInterface(InstallerContext installerContext) {
        ProgressInterface progressInterface = super.getProgressInterface(installerContext);
        if (!this.isShowProgress()) {
            progressInterface = new NoPercentageProgressDelegate(progressInterface);
        }
        return progressInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        ProgressInterface progressInterface = this.getProgressInterface(installerContext);
        try {
            FileInstaller.getInstance().setLogDir(installerContext.getDestinationFile(".install4j"));
            FileInstaller.getInstance().resetCurrentRebootRequired();
            String string = this.getInternalComponentId();
            try {
                ContentInstaller.getInstance().doComponentInstallation(installerContext, progressInterface, string, this);
            }
            catch (ReadIOException readIOException) {
                Logger.getInstance().error(this, "content corrupted.");
                Logger.getInstance().log(readIOException.getCause());
                boolean bl = false;
                return bl;
            }
            catch (UserCanceledException userCanceledException) {
                if (installerContext.isCancelling()) {
                    throw userCanceledException;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.isTriggerReboot() && this.isDelay() && FileInstaller.getInstance().isCurrentRebootRequired()) {
                    installerContext.triggerReboot(true);
                }
            }
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
        }
        catch (IOException iOException) {
            installerContext.handleCriticalException(iOException);
            return false;
        }
        progressInterface.setDetailMessage("");
        return true;
    }

    private String getInternalComponentId() {
        String string = this.getComponentId();
        Iterator iterator = InstallerConfig.getCurrentInstance().getComponents().iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            if (!componentConfig.getCustomizedId().equals(string)) continue;
            return componentConfig.getId();
        }
        return string;
    }
}

