/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteFileAction
extends AbstractRecursiveFileAction {
    private boolean backupForRollback = true;
    private List deletedDirs = new ArrayList();

    public boolean isBackupForRollback() {
        return this.backupForRollback;
    }

    public void setBackupForRollback(boolean bl) {
        this.backupForRollback = bl;
    }

    protected boolean executeForSingleRecursiveFile(Context context, File file, File file2, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        if (!file.isDirectory()) {
            boolean bl;
            this.deleteFile(file, context);
            boolean bl2 = bl = !file.exists();
            if (!bl) {
                Logger.getInstance().log(this, "The file " + file.getPath() + " cannot be deleted", false);
            }
            return bl;
        }
        return true;
    }

    protected boolean postProcessDirectory(Context context, File file) {
        this.deleteDir(file);
        return !this.isRecursive() || !file.exists();
    }

    private void deleteDir(File file) {
        if (this.backupForRollback) {
            this.deletedDirs.add(file);
        }
        file.delete();
    }

    private void deleteFile(File file, Context context) throws UserCanceledException {
        if (context instanceof InstallerContext && this.backupForRollback) {
            BackupFileForRollbackAction backupFileForRollbackAction = new BackupFileForRollbackAction(file, true, false, false);
            backupFileForRollbackAction.install((InstallerContext)context);
            this.addRollbackAction(backupFileForRollbackAction);
        } else {
            file.delete();
        }
    }

    public void rollback(InstallerContext installerContext) {
        for (int i = 0; i < this.deletedDirs.size(); ++i) {
            ((File)this.deletedDirs.get(i)).mkdirs();
        }
        super.rollback(installerContext);
    }

    public boolean isRollbackSupported() {
        return this.backupForRollback;
    }

    protected boolean isErrorIfFileMissing() {
        return false;
    }
}

