/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.macos.PlistHelper;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;

public abstract class AbstractControlServiceAction
extends SystemInstallOrUninstallAction {
    protected static final String METHOD_START = "start";
    protected static final String METHOD_STOP = "stop";
    private File executable;
    private String serviceName;
    private String launcherId = "";

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public File getExecutable() {
        return AbstractControlServiceAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public String getServiceName() {
        return AbstractControlServiceAction.replaceVariables(this.serviceName);
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    protected boolean controlService(Context context, String string) {
        return this.controlService(context, string, false);
    }

    protected boolean controlService(Context context, String string, boolean bl) {
        Object object;
        File file;
        String string2;
        if (Util.isWindows9X()) {
            return false;
        }
        if (this.getLauncherId() == null) {
            string2 = this.getServiceName();
            file = context.getDestinationFile(this.getExecutable());
        } else {
            object = context.getLauncherById(this.getLauncherId());
            if (object == null) {
                Logger.getInstance().log(this, "The launcher with ID " + this.getLauncherId() + " cannot be found", false);
                return false;
            }
            file = context.getDestinationFile(object.getRelativeFileName());
            string2 = object.getName();
        }
        if (InstallerUtil.isWindows() && bl) {
            try {
                if (Win32Services.getStartType(string2) != 2) {
                    return true;
                }
            }
            catch (Win32Services.ServiceException serviceException) {
                Logger.getInstance().log(serviceException);
            }
        }
        Logger.getInstance().info(this, "usedExecutable: " + file);
        if (Util.isWindows()) {
            try {
                return this.execute(string, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        if (!file.exists()) {
            Logger.getInstance().log(this, "The executable " + file + " does not exist", false);
            return false;
        }
        if (Util.isMacOS()) {
            Object object2 = object = string.equals(METHOD_STOP) ? null : this.findIdentifier(file, bl);
            if (object != null) {
                if (((String)object).length() > 0) {
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).suidRoot(true);
                    Integer n = LaunchHelper.launchApplication(launchDescriptor.arguments(new String[]{"load", new File("/Library/LaunchDaemons", (String)object + ".plist").getAbsolutePath()}));
                    if (n != null && n == 0) {
                        n = LaunchHelper.launchApplication(launchDescriptor.arguments(new String[]{string, object}));
                        return n != null && n == 0;
                    }
                    return false;
                }
                return true;
            }
            Integer n = LaunchHelper.launchApplication(new LaunchDescriptor(file).arguments(new String[]{string}).wait(true).executionContext(ExecutionContext.MAXIMUM));
            return n != null && n == 0;
        }
        object = LaunchHelper.launchApplication(new LaunchDescriptor(file).arguments(new String[]{string}).wait(true).executionContext(ExecutionContext.MAXIMUM));
        if (object != null && (Integer)object == 0) {
            return true;
        }
        Logger.getInstance().info(this, file + " " + string + " returned " + object);
        return false;
    }

    private String findIdentifier(File file, boolean bl) {
        File[] fileArray = new File("/Library/LaunchDaemons").listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    Document document = XmlHelper.parseFile(fileArray[i]);
                    String string = XmlHelper.getTextValue(PlistHelper.getFirstChild(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "ProgramArguments"), "string"));
                    if (file.getCanonicalPath().equals(string)) {
                        if (bl && !Boolean.valueOf(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "RunAtLoad").getNodeName()).booleanValue()) {
                            return "";
                        }
                        return XmlHelper.getTextValue(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), "Label"));
                    }
                    continue;
                }
                catch (PlistHelper.NotFoundException notFoundException) {
                    continue;
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
            }
        }
        return null;
    }

    public boolean execute(String string, String string2) {
        try {
            if (string.equals(METHOD_START)) {
                Win32Services.startService(string2);
            } else {
                Win32Services.stopService(string2);
            }
            return true;
        }
        catch (Win32Services.ServiceException serviceException) {
            if (serviceException.getErrorCode() == 1056) {
                Logger.getInstance().info(this, "Service '" + string2 + "' already running.");
                return true;
            }
            if (serviceException.getErrorCode() == 1062) {
                Logger.getInstance().info(this, "Service '" + string2 + "' is not running.");
                return true;
            }
            if (serviceException.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (serviceException.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (serviceException.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service '" + string2 + "' does not exist. You need to install it first.");
            } else if (serviceException.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong.");
            } else {
                Logger.getInstance().log(serviceException);
            }
            return false;
        }
    }
}

