/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.actions.UninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.api.screens.UninstallerScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperUninstallerContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UninstallerContextImpl
extends ContextImpl
implements UninstallerContext {
    private Map idNamespaceToContext = new HashMap();

    public UninstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        UninstallerContextImpl.preLoadLibraries();
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return UninstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
            }
        });
    }

    public static void preLoadLibraries() {
        if (!Util.isWindows() && VersionSpecificHelper.isJava7Helper()) {
            try {
                VersionSpecificHelper.getFileInformation(new File(System.getProperty("java.home")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void applyToScreen(Screen screen, ScreenBeanConfig screenBeanConfig) {
        if (screen instanceof UninstallerScreen) {
            ((UninstallerScreen)screen).setUninstallerContext(this.getIdWrapperUninstallerContext(screenBeanConfig));
        }
    }

    public Context getIdWrapperContext(AbstractBeanConfig abstractBeanConfig) {
        return this.getIdWrapperUninstallerContext(abstractBeanConfig);
    }

    public File getAdditionalUserJarsDir() {
        return null;
    }

    private UninstallerContext getIdWrapperUninstallerContext(AbstractBeanConfig abstractBeanConfig) {
        String string = abstractBeanConfig.getIdNamespace();
        if (string.length() == 0) {
            return this;
        }
        UninstallerContext uninstallerContext = (UninstallerContext)this.idNamespaceToContext.get(string);
        if (uninstallerContext == null) {
            uninstallerContext = new WrapperUninstallerContext(this, string);
            this.idNamespaceToContext.put(string, uninstallerContext);
        }
        return uninstallerContext;
    }

    public boolean performActionInt(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        UninstallerContext uninstallerContext = this.getIdWrapperUninstallerContext(actionBeanConfig);
        return UninstallerContextImpl.performActionIntStatic(actionBeanConfig, uninstallerContext);
    }

    private static boolean performActionIntStatic(ActionBeanConfig actionBeanConfig, UninstallerContext uninstallerContext) throws UserCanceledException {
        ContextImpl.setCurrentContext(uninstallerContext);
        final UninstallAction uninstallAction = (UninstallAction)actionBeanConfig.getOrInstantiateAction(false);
        try {
            boolean bl = UninstallerContextImpl.handlePostActionExecutionState(actionBeanConfig, (ContextImpl.PostActionExecutionState)HelperCommunication.getInstance().fetchObjectChecked(actionBeanConfig.getExecutionContext(), new FetchObjectAction(){

                protected Object fetchValue(Context context) throws UserCanceledException {
                    boolean bl = uninstallAction.uninstall((UninstallerContext)context);
                    return new ContextImpl.PostActionExecutionState(uninstallAction, bl);
                }
            }));
            return bl;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            ContextImpl.setCurrentContext(null);
        }
    }

    public void rollbackActionInt(ActionBeanConfig actionBeanConfig) {
    }

    public boolean isUninstallForUpgrade() {
        return Boolean.getBoolean("install4j.upgradeUninstall");
    }

    public boolean checkStart() {
        ClasspathModificator.addCustomJarsToClasspath(this);
        return super.checkStart();
    }

    public void finish(int n) {
        if (this.isUninstallForUpgrade()) {
            System.setProperty("install4j.noRebootDeletion", "true");
        }
        FileInstaller.getInstance().finishUninstall();
        super.finish(n);
    }

    protected String getRebootMessageId() {
        return "UninstalledAndNeedsRestart";
    }
}

